/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.JCRPath;

public class JCRName {
    protected final String prefix;
    protected final String name;
    protected final String namespace;
    protected final String stringName;
    protected final int hashCode;

    protected JCRName(InternalQName qname, String prefix) {
        this(qname.getNamespace(), qname.getName(), prefix);
    }

    JCRName(JCRPath.PathElement that) {
        this.prefix = that.prefix;
        this.name = that.name;
        this.namespace = that.namespace;
        this.stringName = that.stringName;
        this.hashCode = that.hashCode;
    }

    JCRName(String namespace, String name, String prefix) {
        int hk = 31 + namespace.hashCode();
        hk = hk * 31 + name.hashCode();
        int hashCode = hk * 31 + prefix.hashCode();
        Object stringName = prefix.length() == 0 ? name : prefix + ":" + name;
        this.name = name;
        this.namespace = namespace;
        this.prefix = prefix;
        this.stringName = stringName;
        this.hashCode = hashCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public InternalQName getInternalName() {
        return new InternalQName(this.namespace, this.name);
    }

    public String getAsString() {
        return this.stringName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JCRName) {
            return this.hashCode == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return super.toString() + " (" + this.getAsString() + ")";
    }
}

