/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.web.twitter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.spi.InteractionState;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.twitter.TwitterAccessTokenContext;
import org.gatein.security.oauth.twitter.TwitterProcessor;
import org.gatein.security.oauth.utils.OAuthUtils;
import org.gatein.security.oauth.web.OAuthProviderFilter;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.User;

public class TwitterFilter
extends OAuthProviderFilter<TwitterAccessTokenContext> {
    @Override
    protected OAuthProviderType<TwitterAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("TWITTER", TwitterAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_twitterRequestToken");
    }

    @Override
    protected OAuthPrincipal<TwitterAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<TwitterAccessTokenContext> interactionState) {
        User twitterUser;
        TwitterAccessTokenContext accessTokenContext = (TwitterAccessTokenContext)interactionState.getAccessTokenContext();
        Twitter twitter = ((TwitterProcessor)this.getOauthProviderProcessor()).getAuthorizedTwitterInstance(accessTokenContext);
        try {
            twitterUser = twitter.verifyCredentials();
        }
        catch (TwitterException te) {
            throw new OAuthException(OAuthExceptionCode.TWITTER_ERROR, "Error when obtaining user", (Throwable)te);
        }
        OAuthPrincipal oauthPrincipal = OAuthUtils.convertTwitterUserToOAuthPrincipal((User)twitterUser, (TwitterAccessTokenContext)accessTokenContext, this.getOAuthProvider());
        return oauthPrincipal;
    }
}

