/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.provider.PolarStereographicA;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.NoSuchIdentifierException;

final class StandardDefinitions {
    static final String GREENWICH = "8901";
    static final short ELLIPSOIDAL_2D = 6422;
    static final short ELLIPSOIDAL_3D = 6423;
    static final short SPHERICAL = 6404;
    static final short EARTH_CENTRED = 6500;
    static final short CARTESIAN_2D = 4400;
    static final short UPS_NORTH = 1026;
    static final short UPS_SOUTH = 1027;

    private StandardDefinitions() {
    }

    private static Map<String, Object> properties(int n, String string, String string2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        if (n != 0) {
            hashMap.put("identifiers", new NamedIdentifier((Citation)Citations.EPSG, String.valueOf(n)));
        }
        hashMap.put("name", new NamedIdentifier((Citation)Citations.EPSG, string));
        hashMap.put("alias", string2);
        if (bl) {
            hashMap.put("domainOfValidity", Extents.WORLD);
        }
        return hashMap;
    }

    private static void addWMS(Map<String, Object> map, String string) {
        map.put("identifiers", new NamedIdentifier[]{(NamedIdentifier)map.get("identifiers"), new NamedIdentifier((Citation)Citations.WMS, string)});
    }

    static ProjectedCRS createUniversal(int n, GeographicCRS geographicCRS, boolean bl, double d, double d2, CartesianCS cartesianCS) {
        OperationMethod operationMethod;
        try {
            operationMethod = CoordinateOperations.factoryMT().getOperationMethod(bl ? "Transverse Mercator" : "Polar Stereographic (variant A)");
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            throw new IllegalStateException(noSuchIdentifierException);
        }
        ParameterValueGroup parameterValueGroup = operationMethod.getParameters().createValue();
        String string = bl ? TransverseMercator.Zoner.UTM.setParameters(parameterValueGroup, d, d2) : PolarStereographicA.setParameters(parameterValueGroup, d >= 0.0);
        DefaultConversion defaultConversion = new DefaultConversion(StandardDefinitions.properties(0, string, null, false), operationMethod, null, parameterValueGroup);
        string = geographicCRS.getName().getCode() + " / " + string;
        return new DefaultProjectedCRS(StandardDefinitions.properties(n, string, null, false), geographicCRS, (Conversion)defaultConversion, cartesianCS);
    }

    static GeographicCRS createGeographicCRS(short s, GeodeticDatum geodeticDatum, EllipsoidalCS ellipsoidalCS) {
        String string;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        switch (s) {
            case 4326: {
                string = "WGS 84";
                bl = true;
                string3 = "Horizontal component of 3D system.";
                break;
            }
            case 4322: {
                string = "WGS 72";
                bl = true;
                string3 = "Horizontal component of 3D system.";
                break;
            }
            case 4258: {
                string = "ETRS89";
                string2 = "ETRS89-GRS80";
                string3 = "Horizontal component of 3D system.";
                break;
            }
            case 4269: {
                string = "NAD83";
                string3 = "Geodetic survey.";
                break;
            }
            case 4267: {
                string = "NAD27";
                string3 = "Geodetic survey.";
                break;
            }
            case 4230: {
                string = "ED50";
                string3 = "Geodetic survey.";
                break;
            }
            case 4019: {
                string = "Unknown datum based upon the GRS 1980 ellipsoid";
                bl = true;
                break;
            }
            case 4047: {
                string = "Unspecified datum based upon the GRS 1980 Authalic Sphere";
                bl = true;
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        Map<String, Object> map = StandardDefinitions.properties(s, string, string2, bl);
        map.put("scope", string3);
        return new DefaultGeographicCRS(map, geodeticDatum, ellipsoidalCS);
    }

    static GeodeticDatum createGeodeticDatum(short s, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        String string;
        String string2;
        boolean bl = false;
        switch (s) {
            case 6326: {
                string2 = "World Geodetic System 1984";
                string = "WGS 84";
                bl = true;
                break;
            }
            case 6322: {
                string2 = "World Geodetic System 1972";
                string = "WGS 72";
                bl = true;
                break;
            }
            case 6258: {
                string2 = "European Terrestrial Reference System 1989";
                string = "ETRS89";
                break;
            }
            case 6269: {
                string2 = "North American Datum 1983";
                string = "NAD83";
                break;
            }
            case 6267: {
                string2 = "North American Datum 1927";
                string = "NAD27";
                break;
            }
            case 6230: {
                string2 = "European Datum 1950";
                string = "ED50";
                break;
            }
            case 6019: {
                string2 = "Not specified (based on GRS 1980 ellipsoid)";
                string = null;
                bl = true;
                break;
            }
            case 6047: {
                string2 = "Not specified (based on GRS 1980 Authalic Sphere)";
                string = null;
                bl = true;
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        return new DefaultGeodeticDatum(StandardDefinitions.properties(s, string2, string, bl), ellipsoid, primeMeridian);
    }

    static Ellipsoid createEllipsoid(short s) {
        double d;
        double d2;
        String string;
        String string2 = null;
        boolean bl = true;
        Unit unit = Units.METRE;
        switch (s) {
            case 7030: {
                string = "WGS 84";
                string2 = "WGS84";
                d2 = 6378137.0;
                d = 298.257223563;
                break;
            }
            case 7043: {
                string = "WGS 72";
                string2 = "NWL 10D";
                d2 = 6378135.0;
                d = 298.26;
                break;
            }
            case 7019: {
                string2 = "International 1979";
                string = "GRS 1980";
                d2 = 6378137.0;
                d = 298.257222101;
                break;
            }
            case 7022: {
                string = "International 1924";
                string2 = "Hayford 1909";
                d2 = 6378388.0;
                d = 297.0;
                break;
            }
            case 7008: {
                string = "Clarke 1866";
                bl = false;
                d2 = 6378206.4;
                d = 6356583.8;
                break;
            }
            case 7048: {
                string = "GRS 1980 Authalic Sphere";
                bl = false;
                d = 6371007.0;
                d2 = 6371007.0;
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        Map<String, Object> map = StandardDefinitions.properties(s, string, string2, false);
        if (bl) {
            return DefaultEllipsoid.createFlattenedSphere(map, d2, d, (Unit<Length>)unit);
        }
        return DefaultEllipsoid.createEllipsoid(map, d2, d, (Unit<Length>)unit);
    }

    static PrimeMeridian primeMeridian() {
        HashMap<String, NamedIdentifier> hashMap = new HashMap<String, NamedIdentifier>(4);
        hashMap.put("name", new NamedIdentifier((Citation)Citations.EPSG, "Greenwich"));
        hashMap.put("identifiers", new NamedIdentifier((Citation)Citations.EPSG, GREENWICH));
        return new DefaultPrimeMeridian(hashMap, 0.0, (Unit<Angle>)Units.DEGREE);
    }

    static VerticalCRS createVerticalCRS(short s, VerticalDatum verticalDatum) {
        String string;
        String string2;
        String string3 = "Vertical CS. Axis: height (H).";
        int n = 6499;
        short s2 = 114;
        String string4 = null;
        switch (s) {
            case 5703: {
                string4 = "88";
                string2 = "NAVD88 height";
                string = "North American Vertical Datum of 1988 height (m)";
                break;
            }
            case 5714: {
                string2 = "MSL height";
                string = "mean sea level height";
                break;
            }
            case 5715: {
                string2 = "MSL depth";
                string = "mean sea level depth";
                string3 = "Vertical CS. Axis: depth (D).";
                n = 6498;
                s2 = 113;
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        Map<String, Object> map = StandardDefinitions.properties(n, string3, null, false);
        DefaultVerticalCS defaultVerticalCS = new DefaultVerticalCS(map, StandardDefinitions.createAxis(s2, true));
        map = StandardDefinitions.properties(s, string2, string, true);
        if (string4 != null) {
            StandardDefinitions.addWMS(map, string4);
        }
        return new DefaultVerticalCRS(map, verticalDatum, defaultVerticalCS);
    }

    static VerticalDatum createVerticalDatum(short s) {
        String string;
        String string2;
        switch (s) {
            case 5100: {
                string2 = "Mean Sea Level";
                string = "MSL";
                break;
            }
            case 5103: {
                string2 = "North American Vertical Datum 1988";
                string = "NAVD88";
                break;
            }
            default: {
                throw new AssertionError(s);
            }
        }
        return new DefaultVerticalDatum(StandardDefinitions.properties(s, string2, string, true), VerticalDatumType.GEOIDAL);
    }

    static CoordinateSystem createCoordinateSystem(short s, boolean bl) {
        short s2;
        String string;
        int n = 0;
        int n2 = 2;
        switch (s) {
            case 6422: {
                string = "Ellipsoidal 2D";
                n = 2;
                s2 = 108;
                break;
            }
            case 6423: {
                string = "Ellipsoidal 3D";
                n = 2;
                n2 = 3;
                s2 = 111;
                break;
            }
            case 6404: {
                string = "Spherical";
                n = 1;
                n2 = 3;
                s2 = 63;
                break;
            }
            case 6500: {
                string = "Cartesian 3D (geocentric)";
                n2 = 3;
                s2 = 118;
                break;
            }
            case 4400: {
                string = "Cartesian 2D";
                s2 = 3;
                break;
            }
            case 1026: {
                string = "Cartesian 2D for UPS north";
                s2 = 1067;
                break;
            }
            case 1027: {
                string = "Cartesian 2D for UPS south";
                s2 = 1059;
                break;
            }
            default: {
                if (!bl) {
                    return null;
                }
                throw new AssertionError(s);
            }
        }
        Map<String, Object> map = StandardDefinitions.properties(s, string, null, false);
        CoordinateSystemAxis coordinateSystemAxis = null;
        CoordinateSystemAxis coordinateSystemAxis2 = null;
        CoordinateSystemAxis coordinateSystemAxis3 = null;
        switch (n2) {
            default: {
                throw new AssertionError(n2);
            }
            case 3: {
                s2 = (short)(s2 - 1);
                coordinateSystemAxis3 = StandardDefinitions.createAxis(s2, true);
            }
            case 2: {
                s2 = (short)(s2 - 1);
                coordinateSystemAxis2 = StandardDefinitions.createAxis(s2, true);
            }
            case 1: {
                s2 = (short)(s2 - 1);
                coordinateSystemAxis = StandardDefinitions.createAxis(s2, true);
            }
            case 0: 
        }
        switch (n) {
            default: {
                throw new AssertionError(n);
            }
            case 0: {
                return coordinateSystemAxis3 != null ? new DefaultCartesianCS((Map<String, ?>)map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3) : new DefaultCartesianCS((Map<String, ?>)map, coordinateSystemAxis, coordinateSystemAxis2);
            }
            case 1: {
                return new DefaultSphericalCS((Map<String, ?>)map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
            }
            case 2: 
        }
        return coordinateSystemAxis3 != null ? new DefaultEllipsoidalCS((Map<String, ?>)map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3) : new DefaultEllipsoidalCS((Map<String, ?>)map, coordinateSystemAxis, coordinateSystemAxis2);
    }

    static CoordinateSystemAxis createAxis(short s, boolean bl) {
        AxisDirection axisDirection;
        String string;
        String string2;
        Unit unit = Units.METRE;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        RangeMeaning rangeMeaning = null;
        switch (s) {
            case 1: {
                string2 = "Easting";
                string = "E";
                axisDirection = AxisDirection.EAST;
                break;
            }
            case 2: {
                string2 = "Northing";
                string = "N";
                axisDirection = AxisDirection.NORTH;
                break;
            }
            case 60: {
                string2 = "Spherical latitude";
                string = "\u03a9";
                unit = Units.DEGREE;
                axisDirection = AxisDirection.NORTH;
                d = -90.0;
                d2 = 90.0;
                rangeMeaning = RangeMeaning.EXACT;
                break;
            }
            case 61: {
                string2 = "Spherical longitude";
                string = "\u03b8";
                unit = Units.DEGREE;
                axisDirection = AxisDirection.EAST;
                d = -180.0;
                d2 = 180.0;
                rangeMeaning = RangeMeaning.WRAPAROUND;
                break;
            }
            case 62: {
                string2 = "Geocentric radius";
                string = "r";
                axisDirection = AxisDirection.UP;
                rangeMeaning = RangeMeaning.EXACT;
                d = 0.0;
                break;
            }
            case 106: 
            case 108: {
                string2 = "Geodetic latitude";
                string = "\u03c6";
                unit = Units.DEGREE;
                axisDirection = AxisDirection.NORTH;
                d = -90.0;
                d2 = 90.0;
                rangeMeaning = RangeMeaning.EXACT;
                break;
            }
            case 107: 
            case 109: {
                string2 = "Geodetic longitude";
                string = "\u03bb";
                unit = Units.DEGREE;
                axisDirection = AxisDirection.EAST;
                d = -180.0;
                d2 = 180.0;
                rangeMeaning = RangeMeaning.WRAPAROUND;
                break;
            }
            case 110: {
                string2 = "Ellipsoidal height";
                string = "h";
                axisDirection = AxisDirection.UP;
                break;
            }
            case 114: {
                string2 = "Gravity-related height";
                string = "H";
                axisDirection = AxisDirection.UP;
                break;
            }
            case 113: {
                string2 = "Depth";
                string = "D";
                axisDirection = AxisDirection.DOWN;
                break;
            }
            case 115: {
                string2 = "Geocentric X";
                string = "X";
                axisDirection = AxisDirection.GEOCENTRIC_X;
                break;
            }
            case 116: {
                string2 = "Geocentric Y";
                string = "Y";
                axisDirection = AxisDirection.GEOCENTRIC_Y;
                break;
            }
            case 117: {
                string2 = "Geocentric Z";
                string = "Z";
                axisDirection = AxisDirection.GEOCENTRIC_Z;
                break;
            }
            case 1056: 
            case 1057: {
                string2 = "Easting";
                string = "E";
                axisDirection = CoordinateSystems.directionAlongMeridian(AxisDirection.NORTH, 90.0);
                break;
            }
            case 1058: {
                string2 = "Northing";
                string = "N";
                axisDirection = CoordinateSystems.directionAlongMeridian(AxisDirection.NORTH, 0.0);
                break;
            }
            case 1065: {
                string2 = "Easting";
                string = "E";
                axisDirection = CoordinateSystems.directionAlongMeridian(AxisDirection.SOUTH, 90.0);
                break;
            }
            case 1066: {
                string2 = "Northing";
                string = "N";
                axisDirection = CoordinateSystems.directionAlongMeridian(AxisDirection.SOUTH, 180.0);
                break;
            }
            default: {
                if (!bl) {
                    return null;
                }
                throw new AssertionError(s);
            }
        }
        Map<String, Object> map = StandardDefinitions.properties(s, string2, null, false);
        map.put("minimumValue", d);
        map.put("maximumValue", d2);
        map.put("rangeMeaning", rangeMeaning);
        return new DefaultCoordinateSystemAxis(map, string, axisDirection, unit);
    }
}

