/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.util;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.version.Version;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.constant.DocumentSortField;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.FolderNode;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.model.PermissionEntry;
import org.exoplatform.documents.model.PermissionRole;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.documents.storage.jcr.search.DocumentFileSearchResult;
import org.exoplatform.documents.storage.jcr.util.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class JCRDocumentsUtil {
    private static final Log LOG = ExoLogger.getLogger(JCRDocumentsUtil.class);
    private static final String DEFAULT_GROUPS_HOME_PATH = "/Groups";
    public static final String GROUPS_PATH_ALIAS = "groupsPath";
    public static final String DOCUMENTS_NODE = "Documents";
    private static final String JCR_DATASOURCE_NAME = "jcr";
    public static final String USER_PRIVATE_ROOT_NODE = "Private";
    public static final String USER_PUBLIC_ROOT_NODE = "Public";
    private static final String SPACE_PATH_PREFIX = "/Groups/spaces/";
    protected static final Map<DocumentSortField, String> SORT_FIELDS_ES_CORRESPONDING = new EnumMap<DocumentSortField, String>(DocumentSortField.class);
    protected static final Map<DocumentSortField, String> SORT_FIELDS_JCR_CORRESPONDING = new EnumMap<DocumentSortField, String>(DocumentSortField.class);
    private static String groupsPath;

    private JCRDocumentsUtil() {
    }

    public static Node getGroupNode(NodeHierarchyCreator nodeHierarchyCreator, Session session, String groupId) throws RepositoryException {
        String groupsHomePath = JCRDocumentsUtil.getGroupsPath(nodeHierarchyCreator);
        String groupPath = groupsHomePath + groupId + "/Documents";
        if (session.itemExists(groupPath)) {
            return (Node)session.getItem(groupPath);
        }
        return null;
    }

    public static String getGroupsPath(NodeHierarchyCreator nodeHierarchyCreator) {
        if (groupsPath != null) {
            return groupsPath;
        }
        groupsPath = nodeHierarchyCreator.getJcrPath(GROUPS_PATH_ALIAS);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)groupsPath)) {
            groupsPath = DEFAULT_GROUPS_HOME_PATH;
        }
        return groupsPath;
    }

    public static List<FileNode> toFileNodes(IdentityManager identityManager, NodeIterator nodeIterator, Identity aclIdentity, Session session, SpaceService spaceService, boolean includeHiddenFiles) throws RepositoryException {
        ArrayList<FileNode> fileNodes = new ArrayList<FileNode>();
        JCRDeleteFileStorage jCRDeleteFileStorage = (JCRDeleteFileStorage)CommonsUtils.getService(JCRDeleteFileStorage.class);
        Map documetsToDelete = jCRDeleteFileStorage.getDocumentsToDelete();
        while (nodeIterator.hasNext()) {
            String sourceID = "";
            String sourceMimeType = "";
            Node node = nodeIterator.nextNode();
            if (documetsToDelete.containsKey(((NodeImpl)node).getIdentifier())) continue;
            try {
                FileNode fileNode;
                Node sourceNode = null;
                if (node.isNodeType("exo:symlink")) {
                    sourceID = node.getProperty("exo:uuid").getString();
                    sourceNode = JCRDocumentsUtil.getNodeByIdentifier(session, sourceID);
                    if (sourceNode == null) continue;
                    if (sourceNode.isNodeType("nt:folder") || sourceNode.isNodeType("nt:unstructured")) {
                        List<FileNode> files;
                        if (node.getPath().contains(sourceNode.getPath()) || (files = JCRDocumentsUtil.toFileNodes(identityManager, sourceNode.getNodes(), aclIdentity, session, spaceService, includeHiddenFiles)).isEmpty()) continue;
                        fileNodes.addAll(files);
                        continue;
                    }
                    if (sourceNode.isNodeType("exo:hiddenable") && !includeHiddenFiles) continue;
                    sourceMimeType = JCRDocumentsUtil.getMimeType(sourceNode);
                    fileNode = JCRDocumentsUtil.toFileNode(identityManager, aclIdentity, node, sourceID, spaceService);
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceMimeType)) {
                        fileNode.setMimeType(sourceMimeType);
                    }
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fileNode.getMimeType())) continue;
                    fileNodes.add(fileNode);
                    continue;
                }
                if (node.isNodeType("exo:hiddenable") && !includeHiddenFiles || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(fileNode = JCRDocumentsUtil.toFileNode(identityManager, aclIdentity, node, sourceID, spaceService)).getMimeType())) continue;
                fileNodes.add(fileNode);
            }
            catch (RepositoryException repositoryException) {
                LOG.warn((Object)"Cannot check if the current node is a symlink");
            }
        }
        return fileNodes;
    }

    public static List<AbstractNode> toNodes(IdentityManager identityManager, Session session, NodeIterator nodeIterator, Identity aclIdentity, SpaceService spaceService, boolean includeHiddenFiles, DocumentFolderFilter filter) {
        ArrayList<AbstractNode> fileNodes = new ArrayList<AbstractNode>();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            String sourceID = "";
            Node sourceNode = node;
            try {
                if (node.isNodeType("exo:symlink") && (sourceNode = JCRDocumentsUtil.getNodeByIdentifier(session, sourceID = node.getProperty("exo:uuid").getString())) == null) continue;
                if ((sourceNode.isNodeType("nt:folder") || sourceNode.isNodeType("nt:unstructured")) && !node.isNodeType("exo:hiddenable") && !includeHiddenFiles) {
                    FolderNode folderNode = JCRDocumentsUtil.toFolderNode(identityManager, aclIdentity, node, sourceID, spaceService);
                    fileNodes.add((AbstractNode)folderNode);
                }
                if (!sourceNode.isNodeType("nt:file") || node.isNodeType("exo:hiddenable") || includeHiddenFiles) continue;
                FileNode fileNode = JCRDocumentsUtil.toFileNode(identityManager, aclIdentity, node, sourceID, spaceService);
                fileNode.setMimeType(JCRDocumentsUtil.getMimeType(sourceNode));
                fileNodes.add((AbstractNode)fileNode);
            }
            catch (RepositoryException e) {
                LOG.warn("Error getting Folder Node for search result with path {}", new Object[]{node, e});
            }
        }
        fileNodes.sort((o1, o2) -> {
            if (o1.isFolder() && o2.isFolder() || !o1.isFolder() && !o2.isFolder()) {
                if (filter.getSortField().equals((Object)DocumentSortField.MODIFIED_DATE)) {
                    if (filter.isAscending()) {
                        return (int)(o1.getModifiedDate() - o2.getModifiedDate());
                    }
                    return (int)(o2.getModifiedDate() - o1.getModifiedDate());
                }
                if (filter.getSortField().equals((Object)DocumentSortField.CREATED_DATE)) {
                    if (filter.isAscending()) {
                        return (int)(o1.getCreatedDate() - o2.getCreatedDate());
                    }
                    return (int)(o2.getCreatedDate() - o1.getCreatedDate());
                }
                if (filter.isAscending()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
            if (o1.isFolder()) {
                return -1;
            }
            return 1;
        });
        return fileNodes;
    }

    public static FolderNode toFolderNode(IdentityManager identityManager, Identity aclIdentity, Node node, String sourceID, SpaceService spaceService) {
        try {
            if (node == null) {
                return null;
            }
            FolderNode folderNode = new FolderNode();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceID)) {
                folderNode.setSourceID(sourceID);
            }
            folderNode.setDatasource(JCR_DATASOURCE_NAME);
            folderNode.setPath(node.getPath());
            folderNode.setCloudDriveFolder(node.hasProperty("ecd:connected"));
            JCRDocumentsUtil.retrieveFileProperties(identityManager, node, aclIdentity, (AbstractNode)folderNode, spaceService);
            return folderNode;
        }
        catch (Exception e) {
            try {
                LOG.warn("Error computing Folder Node for search result with path {}", new Object[]{node.getPath(), e});
            }
            catch (Exception e1) {
                LOG.warn("Error computing Folder Node for search result with path {}", new Object[]{node, e});
            }
            return null;
        }
    }

    public static FileNode toFileNode(IdentityManager identityManager, Session session, Identity aclIdentity, SearchResult searchResult, SpaceService spaceService) {
        DocumentFileSearchResult fileSearchResult = (DocumentFileSearchResult)searchResult;
        try {
            FileNode fileNode = new FileNode();
            Node node = JCRDocumentsUtil.getNode(session, fileNode, fileSearchResult);
            JCRDocumentsUtil.toFileNode(identityManager, aclIdentity, node, fileNode, spaceService);
            return fileNode;
        }
        catch (Exception e) {
            LOG.warn("Error computing File Node for search result with id {}", new Object[]{fileSearchResult.getId(), e});
            return null;
        }
    }

    public static FileNode toFileNode(IdentityManager identityManager, Identity aclIdentity, Node node, String sourceID, SpaceService spaceService) {
        if (node == null) {
            return null;
        }
        FileNode fileNode = new FileNode();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceID)) {
            fileNode.setSourceID(sourceID);
        }
        JCRDocumentsUtil.toFileNode(identityManager, aclIdentity, node, fileNode, spaceService);
        return fileNode;
    }

    public static void toFileNode(IdentityManager identityManager, Identity aclIdentity, Node node, FileNode fileNode, SpaceService spaceService) {
        try {
            fileNode.setDatasource(JCR_DATASOURCE_NAME);
            fileNode.setCloudDriveFile(node.hasProperty("ecd:driveUUID"));
            JCRDocumentsUtil.retrieveFileProperties(identityManager, node, aclIdentity, (AbstractNode)fileNode, spaceService);
            if (node.hasNode("jcr:content")) {
                Node content = node.getNode("jcr:content");
                JCRDocumentsUtil.retrieveFileContentProperties(content, fileNode);
            }
        }
        catch (Exception e) {
            try {
                LOG.warn("Error computing File Node for search result with path {}", new Object[]{node.getPath(), e});
            }
            catch (Exception e1) {
                LOG.warn("Error computing File Node for search result with path {}", new Object[]{node, e});
            }
        }
    }

    public static Node getNode(Session session, FileNode fileNode, DocumentFileSearchResult fileSearchResult) throws RepositoryException {
        Node node = JCRDocumentsUtil.getNodeByIdentifier(session, fileSearchResult.getId());
        if (node == null) {
            node = JCRDocumentsUtil.getNodeByPath(session, fileSearchResult.getNodePath());
        }
        if (node == null) {
            return null;
        }
        if (node.isNodeType("nt:frozenNode")) {
            String originalNodeId = node.getProperty("jcr:frozenUuid").getString();
            fileNode.setVersionnedFileId(originalNodeId);
        }
        if (node.hasProperty("exo:uuid")) {
            String targetNodeId = node.getProperty("exo:uuid").getString();
            fileNode.setLinkedFileId(targetNodeId);
            return JCRDocumentsUtil.getNodeById(session, targetNodeId);
        }
        return node;
    }

    public static void retrieveFileProperties(IdentityManager identityManager, Node node, Identity aclIdentity, AbstractNode documentNode, SpaceService spaceService) throws RepositoryException {
        block18: {
            Node sourceNode;
            documentNode.setId(((NodeImpl)node).getIdentifier());
            documentNode.setPath(node.getPath());
            try {
                Node parent = node.getParent();
                if (parent != null) {
                    documentNode.setParentFolderId(((NodeImpl)parent).getIdentifier());
                }
            }
            catch (RepositoryException parent) {
                // empty catch block
            }
            Node versionNode = node;
            if (node.isNodeType("exo:symlink") && (sourceNode = JCRDocumentsUtil.getNodeByIdentifier(node.getSession(), documentNode.getSourceID())) != null) {
                versionNode = sourceNode;
            }
            if (versionNode.isNodeType("mix:versionable") && versionNode.getBaseVersion() != null) {
                documentNode.setVersionable(true);
                Version version = versionNode.getBaseVersion();
                if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)version.getName())) {
                    documentNode.setVersionNumber(version.getName());
                }
            }
            if (node.hasProperty("exo:title")) {
                documentNode.setName(node.getProperty("exo:title").getString());
            } else {
                documentNode.setName(node.getName());
            }
            if (node.hasProperty("exo:dateCreated")) {
                long createdDate = node.getProperty("exo:dateCreated").getDate().getTimeInMillis();
                documentNode.setCreatedDate(createdDate);
            }
            if (node.hasProperty("exo:owner")) {
                String owner = node.getProperty("exo:owner").getString();
                documentNode.setCreatorId(JCRDocumentsUtil.getUserIdentityId(identityManager, owner));
            }
            if (node.hasProperty("exo:dateModified")) {
                Node nodeToModify = node;
                if (node.isNodeType("exo:symlink")) {
                    String sourceNodeId;
                    ManageableRepository repository;
                    RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
                    SessionProvider sessionProvider = SessionProvider.createSystemProvider();
                    Session systemSession = sessionProvider.getSession((repository = repositoryService.getCurrentRepository()).getConfiguration().getDefaultWorkspaceName(), repository);
                    Node sourceNode2 = JCRDocumentsUtil.getNodeByIdentifier(systemSession, sourceNodeId = node.getProperty("exo:uuid").getString());
                    if (sourceNode2 != null && sourceNode2.getProperty("exo:dateModified").getDate().compareTo(node.getProperty("exo:dateModified").getDate()) > 0) {
                        nodeToModify = sourceNode2;
                    }
                }
                long modifiedDate = nodeToModify.getProperty("exo:dateModified").getDate().getTimeInMillis();
                documentNode.setModifiedDate(modifiedDate);
                String modifier = nodeToModify.getProperty("exo:lastModifier").getString();
                documentNode.setModifierId(JCRDocumentsUtil.getUserIdentityId(identityManager, modifier));
            } else {
                documentNode.setModifiedDate(documentNode.getCreatedDate());
                documentNode.setModifierId(documentNode.getCreatorId());
            }
            if (node.hasProperty("dc:description")) {
                try {
                    documentNode.setDescription(node.getProperty("dc:description").getString());
                }
                catch (ValueFormatException e) {
                    Value[] descriptionValues = node.getProperty("dc:description").getValues();
                    if (descriptionValues == null || descriptionValues.length <= 0) break block18;
                    documentNode.setDescription(descriptionValues[0].getString());
                }
            }
        }
        if (node.isNodeType("dc:description")) {
            documentNode.setDescription(node.getProperty("dc:description").getString());
        }
        JCRDocumentsUtil.computeDocumentAcl(node, documentNode, aclIdentity, identityManager, spaceService);
    }

    public static void retrieveFileContentProperties(Node content, FileNode fileNode) throws RepositoryException {
        if (content.hasProperty("dc:description") && content.getProperty("dc:description").getValues().length > 0) {
            fileNode.setDescription(content.getProperty("dc:description").getValues()[0].getString());
        }
        if (content.hasProperty("jcr:mimeType")) {
            fileNode.setMimeType(content.getProperty("jcr:mimeType").getString());
        }
        if (content.hasProperty("jcr:data")) {
            fileNode.setSize(content.getProperty("jcr:data").getLength());
        }
    }

    public static void computeDocumentAcl(Node node, AbstractNode documentNode, Identity aclIdentity, IdentityManager identityManager, SpaceService spaceService) throws RepositoryException {
        boolean canEdit = false;
        boolean canDelete = false;
        ArrayList<PermissionEntry> permissions = new ArrayList<PermissionEntry>();
        String userId = aclIdentity.getUserId();
        ExtendedNode extendedNode = (ExtendedNode)node;
        List permsList = extendedNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            String nodeAclIdentity = accessControlEntry.getIdentity();
            MembershipEntry membershipEntry = accessControlEntry.getMembershipEntry();
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)nodeAclIdentity, (CharSequence)userId) || org.apache.commons.lang3.StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)userId) || membershipEntry != null && aclIdentity.isMemberOf(membershipEntry)) {
                canEdit = canEdit || accessControlEntry.getPermission().contains("set_property");
                boolean bl = canDelete = canDelete || accessControlEntry.getPermission().contains("remove");
            }
            if (membershipEntry != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)membershipEntry.getGroup())) {
                org.exoplatform.social.core.identity.model.Identity identity;
                Space space = spaceService.getSpaceByGroupId(membershipEntry.getGroup());
                if (space == null || (identity = identityManager.getOrCreateSpaceIdentity(space.getPrettyName())) == null) continue;
                permissions.add(new PermissionEntry(identity, accessControlEntry.getPermission(), JCRDocumentsUtil.getPermissionRole(accessControlEntry.getMembershipEntry().getMembershipType())));
                continue;
            }
            org.exoplatform.social.core.identity.model.Identity identity = identityManager.getOrCreateUserIdentity(nodeAclIdentity);
            if (identity == null) continue;
            permissions.add(new PermissionEntry(identity, accessControlEntry.getPermission(), PermissionRole.ALL.name()));
        }
        documentNode.setAcl(new NodePermission(true, canEdit, canDelete, permissions, null, null));
    }

    private static String getPermissionRole(String membershipType) {
        if (membershipType.equals("manager") || membershipType.equals("redactor")) {
            return PermissionRole.MANAGERS_REDACTORS.name();
        }
        return PermissionRole.ALL.name();
    }

    public static Node getNodeByIdentifier(Session session, String nodeId) {
        try {
            return ((ExtendedSession)session).getNodeByIdentifier(nodeId);
        }
        catch (PathNotFoundException e) {
            LOG.info("Node with identifier {} is not found. Ignore search result.", new Object[]{nodeId});
        }
        catch (RepositoryException e) {
            LOG.debug("Error retrieving node with identifier {}. Will attempt to retrieve it by path", new Object[]{nodeId, e});
        }
        return null;
    }

    public static Node getNodeById(Session session, String nodeId) {
        try {
            return session.getNodeByUUID(nodeId);
        }
        catch (PathNotFoundException e) {
            LOG.info("Node with UUID {} is not found. Ignore search result.", new Object[]{nodeId});
        }
        catch (RepositoryException e) {
            LOG.debug("Error retrieving node with UUID {}. Will attempt to retrieve it by path", new Object[]{nodeId, e});
        }
        return null;
    }

    public static Node getNodeByPath(Session session, String nodePath) {
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nodePath) && session.itemExists(nodePath)) {
                return (Node)session.getItem(nodePath);
            }
        }
        catch (PathNotFoundException e) {
            LOG.info("Node with path {} is not found. Ignore search result.", new Object[]{nodePath});
        }
        catch (RepositoryException e) {
            LOG.debug("Error retrieving node with path {}", new Object[]{nodePath, e});
        }
        return null;
    }

    public static Node getIdentityRootNode(SpaceService spaceService, NodeHierarchyCreator nodeHierarchyCreator, String username, org.exoplatform.social.core.identity.model.Identity ownerIdentity, SessionProvider sessionProvider) throws Exception {
        Node identityRootNode = null;
        if (ownerIdentity.isSpace()) {
            Space space = spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId());
            Session session = sessionProvider.getSession(sessionProvider.getCurrentWorkspace(), sessionProvider.getCurrentRepository());
            identityRootNode = JCRDocumentsUtil.getGroupNode(nodeHierarchyCreator, session, space.getGroupId());
        } else if (ownerIdentity.isUser()) {
            SessionProvider systemSession = SessionProvider.createSystemProvider();
            Node identityNode = nodeHierarchyCreator.getUserNode(systemSession, ownerIdentity.getRemoteId());
            Session session = sessionProvider.getSession(sessionProvider.getCurrentWorkspace(), sessionProvider.getCurrentRepository());
            if (username.equals(ownerIdentity.getRemoteId())) {
                String privatePathNode = identityNode.getPath() + "/Private";
                if (session.itemExists(privatePathNode)) {
                    identityRootNode = (Node)session.getItem(privatePathNode);
                }
            } else {
                String publicPathNode = identityNode.getPath() + "/Public";
                identityRootNode = (Node)session.getItem(publicPathNode);
            }
        }
        return identityRootNode;
    }

    public static Node getIdentityRootNode(SpaceService spaceService, NodeHierarchyCreator nodeHierarchyCreator, org.exoplatform.social.core.identity.model.Identity ownerIdentity, Session session) throws Exception {
        SessionProvider systemSession;
        Node identityNode;
        String privatePathNode;
        Node identityRootNode = null;
        if (ownerIdentity.isSpace()) {
            Space space = spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId());
            identityRootNode = JCRDocumentsUtil.getGroupNode(nodeHierarchyCreator, session, space.getGroupId());
        } else if (ownerIdentity.isUser() && session.itemExists(privatePathNode = (identityNode = nodeHierarchyCreator.getUserNode(systemSession = SessionProvider.createSystemProvider(), ownerIdentity.getRemoteId())).getPath() + "/Private")) {
            identityRootNode = (Node)session.getItem(privatePathNode);
        }
        return identityRootNode;
    }

    public static String getSortDirection(DocumentNodeFilter filter) {
        return filter.isAscending() ? "ASC" : "DESC";
    }

    public static String getSortField(DocumentNodeFilter filter, boolean isJcr) {
        DocumentSortField sortField = filter.getSortField();
        if (isJcr) {
            return SORT_FIELDS_JCR_CORRESPONDING.get(sortField);
        }
        return SORT_FIELDS_ES_CORRESPONDING.get(sortField);
    }

    public static SessionProvider getUserSessionProvider(RepositoryService repositoryService, Identity aclIdentity) {
        SessionProvider sessionProvider = new SessionProvider(new ConversationState(aclIdentity));
        try {
            ManageableRepository repository = repositoryService.getCurrentRepository();
            String workspace = repository.getConfiguration().getDefaultWorkspaceName();
            sessionProvider.setCurrentRepository(repository);
            sessionProvider.setCurrentWorkspace(workspace);
            return sessionProvider;
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Can't build a SessionProvider", e);
        }
    }

    public static long getUserIdentityId(IdentityManager identityManager, String username) {
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)IdentityConstants.ANONIM, (CharSequence)username) || org.apache.commons.lang3.StringUtils.equals((CharSequence)IdentityConstants.SYSTEM, (CharSequence)username) || org.apache.commons.lang3.StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)username)) {
            return 0L;
        }
        org.exoplatform.social.core.identity.model.Identity identity = identityManager.getOrCreateUserIdentity(username);
        if (identity != null) {
            return Long.parseLong(identity.getId());
        }
        return 0L;
    }

    public static String cleanName(String oldName) {
        if (StringUtils.isEmpty((String)oldName)) {
            return oldName;
        }
        String extension = "";
        if (oldName.lastIndexOf(".") > -1) {
            extension = oldName.substring(oldName.lastIndexOf("."));
            oldName = oldName.substring(0, oldName.lastIndexOf("."));
        }
        oldName = oldName.trim();
        String specialChar = "&#*@.'\"\t\r\n$\\><:;[]/|";
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < oldName.length(); ++i) {
            char currentChar = oldName.charAt(i);
            if (specialChar.indexOf(currentChar) > -1) {
                ret.append('_');
                continue;
            }
            ret.append(currentChar);
        }
        ret.append(extension);
        return ret.toString();
    }

    public static boolean isValidDocumentTitle(String name) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)FilenameUtils.getBaseName((String)name))) {
            return false;
        }
        Pattern regex = Pattern.compile("[<\\\\>:\"/|?*]");
        Matcher matcher = regex.matcher(name);
        return !matcher.find();
    }

    public static String getMimeType(Node node) {
        try {
            if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static org.exoplatform.social.core.identity.model.Identity getOwnerIdentityFromNodePath(String path, IdentityManager identityManager, SpaceService spaceService) {
        org.exoplatform.social.core.identity.model.Identity identity = null;
        if (path.contains(SPACE_PATH_PREFIX)) {
            String[] pathParts = path.split(SPACE_PATH_PREFIX)[1].split("/");
            String groupId = "/spaces/" + pathParts[0];
            Space space = spaceService.getSpaceByGroupId(groupId);
            if (space != null) {
                identity = identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
            }
        } else if (path.contains(USER_PRIVATE_ROOT_NODE)) {
            String[] pathParts = path.split(USER_PRIVATE_ROOT_NODE)[0].split("/");
            String userName = pathParts[pathParts.length - 1];
            identity = identityManager.getOrCreateUserIdentity(userName);
        } else if (path.contains(USER_PUBLIC_ROOT_NODE)) {
            String[] pathParts = path.split(USER_PUBLIC_ROOT_NODE)[0].split("/");
            String userName = pathParts[pathParts.length - 1];
            identity = identityManager.getOrCreateUserIdentity(userName);
        }
        return identity;
    }

    public static FileVersion toFileVersion(Version version, Node node, IdentityManager identityManager) throws RepositoryException {
        FileVersion versionFileNode = new FileVersion();
        String currentVersionName = node.getBaseVersion().getName();
        Node frozen = version.getNode("jcr:frozenNode");
        if (node.hasProperty("exo:title")) {
            versionFileNode.setTitle(Utils.getStringProperty(node, "exo:title"));
        } else {
            versionFileNode.setTitle(node.getName());
        }
        String userName = frozen.getProperty("exo:lastModifier").getValue().getString();
        Profile profile = identityManager.getOrCreateIdentity("organization", userName).getProfile();
        String[] summary = node.getVersionHistory().getVersionLabels(version);
        if (summary.length > 0) {
            versionFileNode.setSummary(summary[0]);
        }
        versionFileNode.setId(version.getUUID());
        versionFileNode.setFrozenId(frozen.getUUID());
        versionFileNode.setOriginId(node.getUUID());
        versionFileNode.setAuthor(userName);
        versionFileNode.setAuthorFullName(profile.getFullName());
        versionFileNode.setCreatedDate(version.getCreated().getTime());
        versionFileNode.setVersionNumber(Integer.parseInt(version.getName()));
        if (version.getName().equals(currentVersionName)) {
            versionFileNode.setCurrent(true);
        }
        return versionFileNode;
    }

    public static String increaseNameIndex(String origin, int count) {
        int index = origin.indexOf(46);
        if (index == -1) {
            return origin + "(" + count + ")";
        }
        return origin.substring(0, index) + "(" + count + ")" + origin.substring(index);
    }

    public static String getNewIndexedName(String exoTitle, String newNameSuffix) {
        int pointIndex = exoTitle.lastIndexOf(".");
        String extension = pointIndex != -1 ? exoTitle.substring(pointIndex) : "";
        exoTitle = pointIndex != -1 ? exoTitle.substring(0, pointIndex).concat(newNameSuffix).concat(extension) : exoTitle.concat(newNameSuffix);
        return exoTitle;
    }

    static {
        SORT_FIELDS_JCR_CORRESPONDING.put(DocumentSortField.NAME, "exo:title");
        SORT_FIELDS_JCR_CORRESPONDING.put(DocumentSortField.CREATED_DATE, "exo:dateCreated");
        SORT_FIELDS_JCR_CORRESPONDING.put(DocumentSortField.MODIFIED_DATE, "exo:dateModified");
        SORT_FIELDS_ES_CORRESPONDING.put(DocumentSortField.NAME, "title");
        SORT_FIELDS_ES_CORRESPONDING.put(DocumentSortField.CREATED_DATE, "createdDate");
        SORT_FIELDS_ES_CORRESPONDING.put(DocumentSortField.MODIFIED_DATE, "lastUpdatedDate");
        groupsPath = null;
    }
}

