/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage;

import java.util.Collections;
import java.util.List;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityFilterType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.addons.gamification.service.mapper.EntityMapper;
import org.exoplatform.addons.gamification.storage.RuleStorage;
import org.exoplatform.commons.exception.ObjectNotFoundException;

public class ChallengeStorage {
    private RuleStorage ruleStorage;

    public ChallengeStorage(RuleStorage ruleStorage) {
        this.ruleStorage = ruleStorage;
    }

    public Challenge saveChallenge(Challenge challenge, String username) {
        RuleDTO ruleDTO = EntityMapper.fromChallengeToRule(challenge);
        if (ruleDTO.getId() == null) {
            ruleDTO.setCreatedBy(username);
            ruleDTO.setEvent(challenge.getTitle());
        } else {
            RuleDTO storedRuleDTO = this.ruleStorage.findRuleById(ruleDTO.getId());
            ruleDTO.setCreatedBy(storedRuleDTO.getCreatedBy());
            ruleDTO.setEvent(storedRuleDTO.getEvent());
        }
        ruleDTO.setEnabled(challenge.isEnabled());
        ruleDTO.setLastModifiedBy(username);
        ruleDTO = this.ruleStorage.saveRule(ruleDTO);
        return EntityMapper.fromRuleToChallenge(ruleDTO);
    }

    public Challenge deleteChallenge(long challengeId, String username) throws ObjectNotFoundException {
        RuleDTO ruleDTO = this.ruleStorage.deleteRuleById(challengeId, username, true);
        return EntityMapper.fromRuleToChallenge(ruleDTO);
    }

    public List<Long> findChallengesIdsByFilter(RuleFilter ruleFilter, int offset, int limit) {
        ruleFilter.setEntityFilterType(EntityFilterType.MANUAL);
        List<Long> challengesIds = this.ruleStorage.findRulesIdsByFilter(ruleFilter, offset, limit);
        if (challengesIds.isEmpty()) {
            return Collections.emptyList();
        }
        return challengesIds;
    }

    public int countChallengesByFilter(RuleFilter challengeFilter) {
        challengeFilter.setEntityFilterType(EntityFilterType.MANUAL);
        return this.ruleStorage.countRulesByFilter(challengeFilter);
    }

    public Challenge getChallengeById(Long challengeId) {
        RuleDTO ruleDTO = this.ruleStorage.findRuleById(challengeId);
        return EntityMapper.fromRuleToChallenge(ruleDTO);
    }

    public List<Long> findMostRealizedChallengesIds(List<Long> spacesIds, int offset, int limit) {
        return this.ruleStorage.findMostRealizedRuleIds(spacesIds, offset, limit, EntityType.MANUAL);
    }

    public void clearCache() {
        this.ruleStorage.clearCache();
    }
}

