/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.listener;

import javax.jcr.Node;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.documents.notification.utils.NotificationConstants;
import org.exoplatform.documents.notification.utils.NotificationUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ShareDocumentNotificationListener
extends Listener<Identity, Node> {
    private static final String EXO_SYMLINK_UUID = "exo:uuid";
    private SpaceService spaceService;
    private IdentityManager identityManager;

    public ShareDocumentNotificationListener(SpaceService spaceService, IdentityManager identityManager) {
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    public void onEvent(Event<Identity, Node> event) throws Exception {
        Node targetNode = (Node)event.getData();
        Identity targetIdentity = (Identity)event.getSource();
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        String documentLink = null;
        documentLink = targetNode.hasProperty(EXO_SYMLINK_UUID) ? NotificationUtils.getSharedDocumentLink(targetNode, null, null) : NotificationUtils.getDocumentLink(targetNode, this.spaceService, this.identityManager);
        if (targetIdentity.getProviderId().equals("space")) {
            documentLink = NotificationUtils.getSharedDocumentLink(targetNode, this.spaceService, targetIdentity.getRemoteId());
        }
        ctx.append(NotificationConstants.FROM_USER, (Object)currentUser);
        ctx.append(NotificationConstants.DOCUMENT_URL, (Object)documentLink);
        ctx.append(NotificationConstants.DOCUMENT_NAME, (Object)NotificationUtils.getDocumentTitle(targetNode));
        ctx.append(NotificationConstants.RECEIVERS, (Object)targetIdentity.getRemoteId());
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"AddDocumentCollaboratorPlugin"))).execute(ctx);
    }
}

