/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webconferencing.CallProviderConfiguration;
import org.exoplatform.webconferencing.IdentityStateException;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.client.ErrorInfo;
import org.exoplatform.webconferencing.dao.StorageException;

@Path(value="/webconferencing")
@Tag(name="/webconferencing", description="Operations on call providers and participant information")
@Produces(value={"application/json"})
public class RESTWebConferencingService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(RESTWebConferencingService.class);
    protected final WebConferencingService webConferencing;
    private final CacheControl cacheControl;

    public RESTWebConferencingService(WebConferencingService webConferencing) {
        this.webConferencing = webConferencing;
        this.cacheControl = new CacheControl();
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="/provider/{type}/configuration")
    @Operation(summary="Read a call provider configuration", method="GET", description="Use this method to read a call provider configuration. This operation only available to Administrator user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled. Provider configuration object returned."), @ApiResponse(responseCode="401", description="Unauthorized user (conversation state not present). Error code: ACCESS_ERROR"), @ApiResponse(responseCode="404", description="Provider not found. Error code: NOT_FOUND_ERROR"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding or formatting result to JSON. Error code: SERVER_ERROR")})
    public Response getProviderConfig(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Parameter(description="Call provider type, ex: 'webrtc'", required=true) @PathParam(value="type") String type) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            try {
                CallProviderConfiguration conf = this.webConferencing.getProviderConfiguration(type, request.getLocale());
                if (conf != null) {
                    return Response.ok().cacheControl(this.cacheControl).entity((Object)conf).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Provider or configuration not found")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error reading provider configuration for '" + type + "' by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading provider configuration")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Path(value="/provider/{type}/configuration")
    @Operation(summary="Updates a call provider activation status", method="POST", description="Use this method to enable or disable a call provider. This operation only available to Administrator user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled. Updated provider config returned."), @ApiResponse(responseCode="401", description="Unauthorized user (conversation state not present). Error code: ACCESS_ERROR"), @ApiResponse(responseCode="404", description="Provider not found. Error code: NOT_FOUND_ERROR"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding or formatting result to JSON. Error code: SERVER_ERROR")})
    public Response postProviderConfig(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Parameter(description="Call provider type, ex: 'webrtc'", required=true) @PathParam(value="type") String type, @Parameter(description="Activation switch in form of boolean value (case insensitive), 'true' to enable, disable by any other value", required=true) @FormParam(value="active") String active) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            try {
                CallProviderConfiguration conf = this.webConferencing.getProviderConfiguration(type, request.getLocale());
                if (conf != null) {
                    boolean activeVal = Boolean.valueOf(active);
                    if (activeVal != conf.isActive()) {
                        conf.setActive(activeVal);
                        this.webConferencing.saveProviderConfiguration(conf);
                    }
                    return Response.ok().cacheControl(this.cacheControl).entity((Object)conf).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Provider or configuration not found")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error saving provider configuration for '" + type + "' by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error saving provider configuration")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="/providers/configuration")
    @Operation(summary="Read call providers configurations", method="GET", description="Use this method to read all providers configuration. This operation only available to Administrator user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled. Providers configurations returned."), @ApiResponse(responseCode="401", description="Unauthorized user (conversation state not present). Error code: ACCESS_ERROR"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding or formatting result to JSON. Error code: SERVER_ERROR")})
    public Response getProviderConfigs(@Context UriInfo uriInfo, @Context HttpServletRequest request) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            try {
                Set<CallProviderConfiguration> confs = this.webConferencing.getProviderConfigurations(request.getLocale());
                return Response.ok().cacheControl(this.cacheControl).entity(confs).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error reading providers configuration by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading providers configuration")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/user/{name}")
    @Operation(summary="Return user information", method="GET", description="Use this method to read an user info used as call owner or participants. This operation is available to all Platform users.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled. User info object returned."), @ApiResponse(responseCode="400", description="Wrong request parameters: name. Error code: CLIENT_ERROR"), @ApiResponse(responseCode="401", description="Unauthorized user (conversation state not present). Error code: ACCESS_ERROR"), @ApiResponse(responseCode="404", description="User not found. Error code: NOT_FOUND_ERROR"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding or formatting result to JSON. Error code: SERVER_ERROR")})
    public Response getUserInfo(@Context UriInfo uriInfo, @Parameter(description="Call provider name, ex: 'webrtc'", required=true) @PathParam(value="name") String userName) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (userName != null) {
                try {
                    UserInfo user = this.webConferencing.getUserInfo(userName);
                    if (user != null) {
                        return Response.ok().cacheControl(this.cacheControl).entity((Object)user).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("User not found or not accessible")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading user info of '" + userName + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading user " + userName)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/space/{spaceName}")
    @Operation(summary="Return social space information", method="GET", description="Use this method to read a Social space info used as call owner and origins. This operation is available to all Platform users.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled. Space info object returned."), @ApiResponse(responseCode="400", description="Wrong request parameters: spaceName. Error code: CLIENT_ERROR"), @ApiResponse(responseCode="401", description="Unauthorized user (conversation state not present). Error code: ACCESS_ERROR"), @ApiResponse(responseCode="403", description="Not space member. Error code: ACCESS_ERROR"), @ApiResponse(responseCode="404", description="Space not found or not accessible. Error code: NOT_FOUND_ERROR"), @ApiResponse(responseCode="500", description="Internal server error due to data reading from DB, its encoding or formatting result to JSON. Error code: SERVER_ERROR")})
    public Response getSpaceInfo(@Context UriInfo uriInfo, @Parameter(description="Space pretty name, ex: 'sales_team'", required=true) @PathParam(value="spaceName") String spaceName) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (spaceName != null && spaceName.length() > 0) {
                try {
                    WebConferencingService.SpaceInfo space = this.webConferencing.getSpaceInfo(spaceName);
                    if (space != null) {
                        if (space.getMembers().containsKey(currentUserName)) {
                            return Response.ok().cacheControl(this.cacheControl).entity((Object)space).build();
                        }
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Not space member")).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Space not found or not accessible")).build();
                }
                catch (IdentityStateException e) {
                    LOG.error((Object)("Error reading member of space '" + spaceName + "' by '" + currentUserName + "'"), (Throwable)e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading member of space '" + spaceName + "'")).build();
                }
                catch (StorageException e) {
                    LOG.error((Object)("Storage error for space info of '" + spaceName + "' by '" + currentUserName + "'"), (Throwable)e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Storage error for space '" + spaceName + "'")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading space info of '" + spaceName + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading space " + spaceName)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: spaceName")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/space-event/{spaceIdentityId}")
    @Operation(summary="Return a Social space event information", method="GET", description="Use this method to read a Social space event used as call origin. This operation is available to all Platform users.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled. Space event info object returned."), @ApiResponse(responseCode="400", description="Wrong request parameters: spaceName. Error code: CLIENT_ERROR"), @ApiResponse(responseCode="400", description="Wrong request parameters: participants. Error code: CLIENT_ERROR"), @ApiResponse(responseCode="400", description="Wrong request parameters: spaces. Error code: CLIENT_ERROR"), @ApiResponse(responseCode="401", description="Unauthorized user (conversation state not present). Error code: ACCESS_ERROR"), @ApiResponse(responseCode="403", description="Not space member. Error code: ACCESS_ERROR"), @ApiResponse(responseCode="404", description="Space not found or not accessible. Error code: NOT_FOUND_ERROR"), @ApiResponse(responseCode="500", description="Internal server error due to data reading from DB, its encoding or formatting result to JSON. Error code: SERVER_ERROR")})
    public Response getSpaceEventInfo(@Context UriInfo uriInfo, @Parameter(description="Space pretty name used as the event host, ex: 'sales_team'", required=true) @PathParam(value="spaceIdentityId") String spaceIdentityId, @Parameter(description="Participants directly invited to the event, a string of comma-separated names, ex: 'john,mary,james'", required=true) @QueryParam(value="participants") String participants, @Parameter(description="Space pretty names for inviting its participants to the event, a string of comma-separated names, ex: 'sales_team,acme_project,ux_pride'", required=true) @QueryParam(value="spaces") String spaces) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (spaceIdentityId != null && spaceIdentityId.length() > 0) {
                if (participants != null && participants.length() > 0) {
                    if (spaces != null && spaces.length() > 0) {
                        try {
                            WebConferencingService.SpaceEventInfo space = this.webConferencing.getSpaceEventInfo(spaceIdentityId, participants.trim().split(";"), spaces.trim().split(";"));
                            if (space != null) {
                                if (space.getMembers().containsKey(currentUserName)) {
                                    return Response.ok().cacheControl(this.cacheControl).entity((Object)space).build();
                                }
                                return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Not space member")).build();
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Space not found or not accessible")).build();
                        }
                        catch (IdentityStateException e) {
                            LOG.error((Object)("Error reading member of space with id'" + spaceIdentityId + "' by '" + currentUserName + "'"), (Throwable)e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading member of space with id'" + spaceIdentityId + "'")).build();
                        }
                        catch (StorageException e) {
                            LOG.error((Object)("Storage error for space event info of space with id'" + spaceIdentityId + "' by '" + currentUserName + "'"), (Throwable)e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Storage error for space with id'" + spaceIdentityId + "'")).build();
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Error reading space event info of space with id'" + spaceIdentityId + "' by '" + currentUserName + "'"), e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading space with id" + spaceIdentityId)).build();
                        }
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: spaces")).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: participants")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: spaceName")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/room/{id}")
    @Operation(summary="Return chat room information", method="GET", description="Use this method to chat room info used as call owner and origins. This operation is available to all Platform users.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled. Chat room info object returned."), @ApiResponse(responseCode="400", description="Wrong request parameters: id. Error code: CLIENT_ERROR"), @ApiResponse(responseCode="400", description="Wrong request parameters: title. Error code: CLIENT_ERROR"), @ApiResponse(responseCode="400", description="Wrong request parameters: members. Error code: CLIENT_ERROR"), @ApiResponse(responseCode="401", description="Unauthorized user (conversation state not present). Error code: ACCESS_ERROR"), @ApiResponse(responseCode="403", description="Not room member. Error code: ACCESS_ERROR"), @ApiResponse(responseCode="404", description="Room not found or not accessible. Error code: NOT_FOUND_ERROR"), @ApiResponse(responseCode="500", description="Internal server error due to data reading from DB, its encoding or formatting result to JSON. Error code: SERVER_ERROR")})
    public Response getRoomInfo(@Context UriInfo uriInfo, @Parameter(description="Room ID, ex: 'team-ec5e257858734e40a98505475d8eedc4'", required=true) @PathParam(value="id") String roomId, @Parameter(description="Room title, ex: 'ACME meetings'", required=true) @QueryParam(value="title") String roomTitle, @Parameter(description="Room members (platform users or external Chat users), a string of comma-separated names, ex: 'john,james,julia'", required=true) @QueryParam(value="members") String roomMembers) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (roomId != null && roomId.length() > 0) {
                if (roomTitle != null && roomTitle.length() > 0) {
                    if (roomMembers != null && roomMembers.length() > 0) {
                        try {
                            WebConferencingService.RoomInfo room = this.webConferencing.getRoomInfo(roomId, roomTitle, roomMembers.trim().split(";"));
                            if (room != null) {
                                if (room.getMembers().containsKey(currentUserName)) {
                                    return Response.ok().cacheControl(this.cacheControl).entity((Object)room).build();
                                }
                                return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Not room member")).build();
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Room not found or not accessible")).build();
                        }
                        catch (IdentityStateException e) {
                            LOG.error((Object)("Error reading member of room '" + roomTitle + "' by '" + currentUserName + "'"), (Throwable)e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading member of room '" + roomTitle + "'")).build();
                        }
                        catch (StorageException e) {
                            LOG.error((Object)("Storage error for room info of '" + roomTitle + "' by '" + currentUserName + "'"), (Throwable)e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Storage error for room '" + roomTitle + "'")).build();
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Error reading room info of '" + roomTitle + "' by '" + currentUserName + "'"), e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading room '" + roomTitle + "'")).build();
                        }
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: members")).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: title")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: id")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }
}

