/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.setting.badge.impl;

import java.io.InputStream;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.addons.gamification.service.configuration.BadgeService;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;
import org.exoplatform.addons.gamification.service.setting.badge.BadgeRegistry;
import org.exoplatform.addons.gamification.service.setting.badge.model.BadgeConfig;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class BadgeRegistryImpl
implements Startable,
BadgeRegistry {
    private static final Log LOG = ExoLogger.getLogger(BadgeRegistryImpl.class);
    private final Map<String, BadgeConfig> badgesMap = new HashMap<String, BadgeConfig>();
    private BadgeService badgeService;
    private FileService fileService;

    public BadgeRegistryImpl(FileService fileService, BadgeService badgeService) {
        this.fileService = fileService;
        this.badgeService = badgeService;
    }

    @Override
    public void addPlugin(BadgeConfig badge) {
        this.badgesMap.put(badge.getTitle(), badge);
    }

    @Override
    public boolean remove(BadgeConfig badge) {
        this.badgesMap.remove(badge.getTitle());
        return true;
    }

    public void start() {
        try {
            List<BadgeDTO> badges = this.badgeService.getAllBadges();
            if (badges.isEmpty()) {
                for (BadgeConfig badge : this.badgesMap.values()) {
                    this.store(badge);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when processing Rules ", (Throwable)e);
        }
    }

    public void stop() {
    }

    private void store(BadgeConfig badgeConfig) throws ObjectAlreadyExistsException {
        BadgeDTO badgeDTO = new BadgeDTO();
        badgeDTO.setTitle(badgeConfig.getTitle());
        badgeDTO.setDescription(badgeConfig.getDescription());
        badgeDTO.setIconFileId(this.storeIcon(badgeConfig.getIcon()));
        badgeDTO.setNeededScore(badgeConfig.getNeededScore());
        badgeDTO.setEnabled(badgeConfig.isEnable());
        badgeDTO.setDeleted(false);
        badgeDTO.setLastModifiedDate(LocalDate.now().toString());
        badgeDTO.setLastModifiedBy("Gamification");
        badgeDTO.setCreatedBy("Gamification");
        badgeDTO.setCreatedDate(LocalDate.now().toString());
        this.badgeService.addBadge(badgeDTO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long storeIcon(String iconTitle) {
        try (InputStream inputStream = BadgeRegistryImpl.class.getClassLoader().getResourceAsStream("medias/images/" + iconTitle);){
            if (inputStream == null) {
                long l2 = 0L;
                return l2;
            }
            FileItem fileItem = new FileItem(null, iconTitle, "image/png", "gamification", (long)inputStream.available(), new Date(), "gamification", false, inputStream);
            fileItem = this.fileService.writeFile(fileItem);
            long l = fileItem.getFileInfo().getId();
            return l;
        }
        catch (Exception e) {
            LOG.error("Enable to inject icon for badge {} ", new Object[]{iconTitle, e});
            return 0L;
        }
    }
}

