/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.metadata.favorite;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.metadata.FavoriteACLPlugin;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.metadata.favorite.model.FavoriteObject;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;

public class FavoriteServiceImpl
implements FavoriteService {
    private final MetadataService metadataService;
    private final Map<String, FavoriteACLPlugin> favoriteACLPluginMap = new HashMap<String, FavoriteACLPlugin>();

    public FavoriteServiceImpl(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void createFavorite(Favorite favorite) throws ObjectAlreadyExistsException {
        long userIdentityId = favorite.getUserIdentityId();
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE.getName(), String.valueOf(userIdentityId), userIdentityId);
        FavoriteObject object = favorite.getObject();
        this.metadataService.createMetadataItem((MetadataObject)object, metadataKey, userIdentityId);
    }

    public void addFavoriteACLPlugin(FavoriteACLPlugin favoriteACLPlugin) {
        this.favoriteACLPluginMap.put(favoriteACLPlugin.getEntityType(), favoriteACLPlugin);
    }

    public boolean canCreateFavorite(Identity userIdentity, String objectType, String objectId) {
        FavoriteACLPlugin favoriteACLPlugin = this.favoriteACLPluginMap.get(objectType);
        if (favoriteACLPlugin != null) {
            return favoriteACLPlugin.canCreateFavorite(userIdentity, objectId);
        }
        return true;
    }

    public List<MetadataItem> getFavoriteItemsByCreator(long creatorId, long offset, long limit) {
        return this.metadataService.getMetadataItemsByMetadataTypeAndCreator(METADATA_TYPE.getName(), creatorId, offset, limit);
    }

    public List<MetadataItem> getFavoriteItemsByCreatorAndType(String objectType, long creatorId, long offset, long limit) {
        return this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(String.valueOf(creatorId), METADATA_TYPE.getName(), objectType, offset, limit);
    }

    public List<MetadataItem> getFavoriteItemsByCreatorAndTypeAndSpaceId(String objectType, long creatorId, long spaceId, long offset, long limit) {
        return this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceId(String.valueOf(creatorId), METADATA_TYPE.getName(), objectType, spaceId, offset, limit);
    }

    public int getFavoriteItemsSize(long creatorId) {
        return this.metadataService.countMetadataItemsByMetadataTypeAndCreator(METADATA_TYPE.getName(), creatorId);
    }

    public boolean isFavorite(Favorite favorite) {
        long userIdentityId = favorite.getUserIdentityId();
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE.getName(), String.valueOf(userIdentityId), userIdentityId);
        List favorites = this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, (MetadataObject)favorite.getObject());
        return !favorites.isEmpty();
    }

    public void deleteFavorite(Favorite favorite) throws ObjectNotFoundException {
        long userIdentityId = favorite.getUserIdentityId();
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE.getName(), String.valueOf(userIdentityId), userIdentityId);
        List favorites = this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, (MetadataObject)favorite.getObject());
        if (CollectionUtils.isEmpty((Collection)favorites)) {
            throw new ObjectNotFoundException("Favorite entity not found for favorite " + favorite);
        }
        for (MetadataItem favoriteItem : favorites) {
            this.metadataService.deleteMetadataItem(favoriteItem.getId(), userIdentityId);
        }
    }
}

