/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.serialize;

import org.exoplatform.portal.application.Preference;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.JibxArraySerialize;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.jibx.runtime.IAliasable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;

public class AbstractApplicationHandler
implements IMarshaller,
IUnmarshaller,
IAliasable {
    private String m_uri;
    private int m_index;
    private String m_name;

    public AbstractApplicationHandler() {
    }

    public AbstractApplicationHandler(String m_uri, int m_index, String m_name) {
        this.m_uri = m_uri;
        this.m_index = m_index;
        this.m_name = m_name;
    }

    public boolean isExtension(String s) {
        throw new UnsupportedOperationException();
    }

    public void marshal(Object o, IMarshallingContext iMarshallingContext) throws JiBXException {
        throw new UnsupportedOperationException();
    }

    public boolean isPresent(IUnmarshallingContext ctx) throws JiBXException {
        return ctx.isAt(this.m_uri, this.m_name);
    }

    public Object unmarshal(Object obj, IUnmarshallingContext ictx) throws JiBXException {
        TransientApplicationState<Object> state;
        UnmarshallingContext ctx = (UnmarshallingContext)ictx;
        if (!ctx.isAt(this.m_uri, this.m_name)) {
            ctx.throwStartTagNameError(this.m_uri, this.m_name);
        }
        if (obj != null) {
            throw new AssertionError((Object)"That should not happen");
        }
        String id = this.optionalAttribute(ctx, "id");
        ctx.parsePastStartTag(this.m_uri, this.m_name);
        if (!ctx.isAt(this.m_uri, "portlet")) {
            return null;
        }
        ctx.parsePastStartTag(this.m_uri, "portlet");
        String applicationName = ctx.parseElementText(this.m_uri, "application-ref");
        String portletName = ctx.parseElementText(this.m_uri, "portlet-ref");
        String contentId = applicationName + "/" + portletName;
        Application<Portlet> app = Application.createPortletApplication();
        if (ctx.isAt(this.m_uri, "preferences")) {
            PortletBuilder builder = new PortletBuilder();
            ctx.parsePastStartTag(this.m_uri, "preferences");
            while (ctx.isAt(this.m_uri, "preference")) {
                Preference value = (Preference)ctx.unmarshalElement();
                builder.add(value.getName(), value.getValues(), value.isReadOnly());
            }
            ctx.parsePastEndTag(this.m_uri, "preferences");
            state = new TransientApplicationState<Portlet>(contentId, builder.build());
        } else {
            state = new TransientApplicationState<Object>(contentId, null);
        }
        ctx.parsePastEndTag(this.m_uri, "portlet");
        app.setState(state);
        this.nextOptionalTag(ctx, "application-type");
        String theme = this.nextOptionalTag(ctx, "theme");
        String title = this.nextOptionalTag(ctx, "title");
        String accessPermissions = this.nextOptionalTag(ctx, "access-permissions");
        boolean showInfoBar = this.nextOptionalBooleanTag(ctx, "show-info-bar", true);
        boolean showApplicationState = this.nextOptionalBooleanTag(ctx, "show-application-state", true);
        boolean showApplicationMode = this.nextOptionalBooleanTag(ctx, "show-application-mode", true);
        String description = this.nextOptionalTag(ctx, "description");
        String icon = this.nextOptionalTag(ctx, "icon");
        String width = this.nextOptionalTag(ctx, "width");
        String height = this.nextOptionalTag(ctx, "height");
        Properties properties = null;
        if (ctx.isAt(this.m_uri, "properties")) {
            properties = (Properties)ctx.unmarshalElement();
        }
        ctx.parsePastEndTag(this.m_uri, this.m_name);
        app.setId(id);
        app.setTheme(theme);
        app.setTitle(title);
        app.setAccessPermissions(JibxArraySerialize.deserializeStringArray(accessPermissions));
        app.setShowInfoBar(showInfoBar);
        app.setShowApplicationState(showApplicationState);
        app.setShowApplicationMode(showApplicationMode);
        app.setDescription(description);
        app.setIcon(icon);
        app.setWidth(width);
        app.setHeight(height);
        app.setProperties(properties);
        return app;
    }

    private String optionalAttribute(UnmarshallingContext ctx, String attrName) throws JiBXException {
        String value = null;
        if (ctx.hasAttribute(this.m_uri, attrName)) {
            value = ctx.attributeText(this.m_uri, attrName);
        }
        return value;
    }

    private String nextOptionalTag(UnmarshallingContext ctx, String tagName) throws JiBXException {
        String value = null;
        if (ctx.isAt(this.m_uri, tagName)) {
            value = ctx.parseElementText(this.m_uri, tagName);
        }
        return value;
    }

    private boolean nextOptionalBooleanTag(UnmarshallingContext ctx, String tagName, boolean defaultValue) throws JiBXException {
        Boolean value = defaultValue;
        if (ctx.isAt(this.m_uri, tagName)) {
            value = ctx.parseElementBoolean(this.m_uri, tagName);
        }
        return value;
    }
}

