/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.state.producer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.pc.api.InvalidPortletIdException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.PortletStatus;
import org.gatein.pc.api.StateEvent;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.PreferenceInfo;
import org.gatein.pc.api.info.PreferencesInfo;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.InvocationException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.state.AbstractPropertyContext;
import org.gatein.pc.portlet.state.InvalidStateIdException;
import org.gatein.pc.portlet.state.NoSuchStateException;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.pc.portlet.state.StateConversionException;
import org.gatein.pc.portlet.state.StateConverter;
import org.gatein.pc.portlet.state.StateManagementPolicy;
import org.gatein.pc.portlet.state.producer.PortletState;
import org.gatein.pc.portlet.state.producer.PortletStateChangeRequiredException;
import org.gatein.pc.portlet.state.producer.PortletStateContext;
import org.gatein.pc.portlet.state.producer.PortletStatePersistenceManager;
import org.gatein.pc.portlet.state.producer.ProducerPortlet;

public class ProducerPortletInvoker
extends PortletInvokerInterceptor {
    private PortletStatePersistenceManager persistenceManager;
    private StateManagementPolicy stateManagementPolicy;
    private StateConverter stateConverter;
    private final Log log = ExoLogger.getLogger(ProducerPortletInvoker.class);

    public ProducerPortletInvoker() {
    }

    public ProducerPortletInvoker(PortletStatePersistenceManager persistenceManager, StateManagementPolicy stateManagementPolicy, StateConverter stateConverter) {
        this.persistenceManager = persistenceManager;
        this.stateManagementPolicy = stateManagementPolicy;
        this.stateConverter = stateConverter;
    }

    public PortletStatePersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public void setPersistenceManager(PortletStatePersistenceManager ppm) {
        this.persistenceManager = ppm;
    }

    public StateManagementPolicy getStateManagementPolicy() {
        return this.stateManagementPolicy;
    }

    public void setStateManagementPolicy(StateManagementPolicy stateManagementPolicy) {
        this.stateManagementPolicy = stateManagementPolicy;
    }

    public StateConverter getStateConverter() {
        return this.stateConverter;
    }

    public void setStateConverter(StateConverter stateConverter) {
        this.stateConverter = stateConverter;
    }

    @Override
    public Portlet getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        return this._getPortlet(portletContext);
    }

    @Override
    public PortletStatus getStatus(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        PortletStatus status = super.getStatus(portletContext);
        if (status != null) {
            return status;
        }
        try {
            Portlet portlet = this.getPortlet(portletContext);
            return portlet != null ? PortletStatus.MANAGED : null;
        }
        catch (NoSuchPortletException e) {
            return null;
        }
    }

    private <S extends Serializable> Portlet _getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        if (portletContext == null) {
            throw new IllegalArgumentException("No null portlet id accepted");
        }
        String portletId = portletContext.getId();
        if ("_dumbvalue".equals(portletId)) {
            if (portletContext instanceof StatefulPortletContext) {
                StatefulPortletContext statefulPortletContext = (StatefulPortletContext)portletContext;
                Serializable state = statefulPortletContext.getState();
                try {
                    PortletState portletState = this.stateConverter.unmarshall(statefulPortletContext.getType(), state);
                    Portlet delegate = super.getPortlet(PortletContext.createPortletContext((String)portletState.getPortletId()));
                    return new ProducerPortlet(portletContext, delegate);
                }
                catch (StateConversionException e) {
                    throw new PortletInvokerException((Throwable)e);
                }
            }
            throw new InvalidPortletIdException("", portletId);
        }
        if (portletId.startsWith("_")) {
            try {
                String stateId = portletId.substring("_".length());
                PortletStateContext stateContext = this.persistenceManager.loadState(stateId);
                PortletState state = stateContext.getState();
                Portlet delegate = super.getPortlet(PortletContext.createPortletContext((String)state.getPortletId()));
                return new ProducerPortlet(portletContext, delegate);
            }
            catch (NoSuchStateException e) {
                throw new NoSuchPortletException((Throwable)e, portletId);
            }
            catch (InvalidStateIdException e) {
                throw new InvalidPortletIdException((Throwable)e, portletId);
            }
        }
        return super.getPortlet(portletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException, InvocationException {
        PortletInvocationResponse response;
        Portlet portlet;
        PortletContext portletContext = invocation.getTarget();
        if (portletContext == null) {
            throw new InvocationException("No portlet context provided");
        }
        InstanceContext instanceCtx = invocation.getInstanceContext();
        AccessMode access = instanceCtx.getAccessMode();
        InternalContext context = this.getStateContext(portletContext);
        if (!context.isStateful() && access == AccessMode.READ_WRITE) {
            access = AccessMode.READ_ONLY;
        }
        if ((portlet = super.getPortlet(context.getPortletContext())) == null) {
            throw new NoSuchPortletException("Portlet " + context.getPortletContext() + " not found", context.getPortletId());
        }
        AbstractPropertyContext prefs = new AbstractPropertyContext(access, context.isStateful() ? ((StatefulContext)context).getProperties() : null, invocation instanceof RenderInvocation);
        try {
            invocation.setTarget(context.getPortletContext());
            invocation.setAttribute("preferences", (Object)prefs);
            response = super.invoke(invocation);
        }
        finally {
            invocation.setTarget(portletContext);
            invocation.removeAttribute((Object)"preferences");
        }
        int status = prefs.getStatus();
        if ((invocation instanceof ActionInvocation || invocation instanceof ResourceInvocation || invocation instanceof EventInvocation) && status == 2) {
            PropertyMap newPrefs = prefs.getPrefs();
            PortletStateType stateType = instanceCtx.getStateType();
            boolean persistLocally = stateType == null ? true : this.stateManagementPolicy.persistLocally();
            switch (access) {
                case CLONE_BEFORE_WRITE: {
                    if (context.isStateful()) {
                        StatefulContext statefulContext = (StatefulContext)context;
                        if (persistLocally) {
                            try {
                                LocalContext localContext = (LocalContext)statefulContext;
                                String portletStateId = localContext.getStateId();
                                String cloneStateId = this.persistenceManager.cloneState(portletStateId, newPrefs);
                                String cloneId = "_" + cloneStateId;
                                PortletContext clonedCtx = PortletContext.createPortletContext((String)cloneId);
                                StateEvent event = new StateEvent(clonedCtx, StateEvent.Type.PORTLET_CLONED_EVENT);
                                instanceCtx.onStateEvent(event);
                                break;
                            }
                            catch (NoSuchStateException e) {
                                throw new PortletInvokerException("Unexpected exception", (Throwable)e);
                            }
                            catch (InvalidStateIdException e) {
                                throw new PortletInvokerException("Unexpected exception", (Throwable)e);
                            }
                        }
                        PortletContext clonedCtx = this.marshall(stateType, context.getPortletId(), newPrefs);
                        StateEvent event = new StateEvent(clonedCtx, StateEvent.Type.PORTLET_CLONED_EVENT);
                        instanceCtx.onStateEvent(event);
                        break;
                    }
                    this.getPropertiesFromMetaData(portlet.getContext(), newPrefs);
                    if (persistLocally) {
                        String cloneStateId = this.persistenceManager.createState(context.getPortletId(), newPrefs);
                        String cloneId = "_" + cloneStateId;
                        PortletContext clonedCtx = PortletContext.createPortletContext((String)cloneId);
                        StateEvent event = new StateEvent(clonedCtx, StateEvent.Type.PORTLET_CLONED_EVENT);
                        instanceCtx.onStateEvent(event);
                        break;
                    }
                    PortletContext clonedCtx = this.marshall(stateType, context.getPortletId(), newPrefs);
                    StateEvent event = new StateEvent(clonedCtx, StateEvent.Type.PORTLET_CLONED_EVENT);
                    instanceCtx.onStateEvent(event);
                    break;
                }
                case READ_WRITE: {
                    StatefulContext statefulContext = (StatefulContext)context;
                    if (statefulContext.isLocal()) {
                        try {
                            LocalContext localContext = (LocalContext)statefulContext;
                            String stateId = localContext.getStateId();
                            this.persistenceManager.updateState(stateId, newPrefs);
                            break;
                        }
                        catch (NoSuchStateException e) {
                            throw new PortletInvokerException("Unexpected exception", (Throwable)e);
                        }
                        catch (InvalidStateIdException e) {
                            throw new PortletInvokerException("Unexpected exception", (Throwable)e);
                        }
                    }
                    PortletContext modifiedCtx = this.marshall(stateType, context.getPortletId(), newPrefs);
                    StateEvent event = new StateEvent(modifiedCtx, StateEvent.Type.PORTLET_MODIFIED_EVENT);
                    instanceCtx.onStateEvent(event);
                    break;
                }
                case READ_ONLY: {
                    throw new PortletStateChangeRequiredException("Modification was requested for portlet with id '" + context.getPortletId() + "' but access mode was READ ONLY.");
                }
            }
        }
        return response;
    }

    @Override
    public PortletContext createClone(PortletStateType stateType, PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (portletContext == null) {
            throw new IllegalArgumentException("No null portlet context accepted");
        }
        String portletId = portletContext.getId();
        InternalContext context = this.getStateContext(portletContext);
        boolean persistLocally = stateType == null ? true : this.stateManagementPolicy.persistLocally();
        if (context.isStateful()) {
            StatefulContext statefulContext = (StatefulContext)context;
            if (persistLocally) {
                try {
                    String stateId = portletId.substring("_".length());
                    String cloneId = "_" + this.persistenceManager.cloneState(stateId);
                    return PortletContext.createPortletContext((String)cloneId);
                }
                catch (NoSuchStateException e) {
                    throw new NoSuchPortletException((Throwable)e, portletId);
                }
                catch (InvalidStateIdException e) {
                    throw new InvalidPortletIdException((Throwable)e, portletId);
                }
            }
            return this.marshall(stateType, statefulContext.getPortletId(), statefulContext.getProperties());
        }
        SimplePropertyMap newState = new SimplePropertyMap();
        this.getPropertiesFromMetaData(portletContext, newState);
        if (persistLocally) {
            String cloneId = this.persistenceManager.createState(portletId, newState);
            return PortletContext.createPortletContext((String)("_" + cloneId));
        }
        return this.marshall(stateType, portletId, newState);
    }

    @Override
    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (portletContexts == null) {
            throw new IllegalArgumentException("No portlet contexts provided");
        }
        ArrayList<DestroyCloneFailure> result = new ArrayList<DestroyCloneFailure>();
        for (PortletContext portletContext : portletContexts) {
            DestroyCloneFailure failure;
            if (portletContext instanceof StatefulPortletContext) continue;
            String portletId = portletContext.getId();
            if (!portletId.startsWith("_")) {
                this.log.debug((Object)("Attempt to destroy a producer offered portlet " + portletId));
                DestroyCloneFailure failure2 = new DestroyCloneFailure(portletId, "Cannot destroy POP");
                result.add(failure2);
                continue;
            }
            try {
                this.persistenceManager.destroyState(portletId.substring("_".length()));
            }
            catch (NoSuchStateException e) {
                this.log.debug((Object)("Attempt to destroy a non existing portlet " + portletId));
                failure = new DestroyCloneFailure(portletId, "Not found");
                result.add(failure);
            }
            catch (InvalidStateIdException e) {
                this.log.debug((Object)("Attempt to destroy a non valid portlet " + portletId));
                failure = new DestroyCloneFailure(portletId, "Invalid portlet id");
                result.add(failure);
            }
        }
        return result;
    }

    @Override
    public PropertyMap getProperties(PortletContext portletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (keys == null) {
            throw new IllegalArgumentException("No keys provided");
        }
        PropertyMap props = this.getProperties(portletContext);
        props.keySet().retainAll(keys);
        return props;
    }

    @Override
    public PropertyMap getProperties(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (portletContext == null) {
            throw new IllegalArgumentException("No null portlet id is accepted");
        }
        String portletId = portletContext.getId();
        InternalContext context = this.getStateContext(portletContext);
        if (context.isStateful()) {
            StatefulContext statefulContext = (StatefulContext)context;
            SimplePropertyMap props = new SimplePropertyMap(statefulContext.getProperties());
            PortletContext refPortletContext = context.getPortletContext();
            Portlet refPortlet = super.getPortlet(refPortletContext);
            if (refPortlet == null) {
                throw new PortletInvokerException("The portlet " + refPortletContext + " referenced by this clone " + portletId + " is not available");
            }
            this.getPropertiesFromMetaData(refPortletContext, props);
            return props;
        }
        SimplePropertyMap props = new SimplePropertyMap();
        this.getPropertiesFromMetaData(context.getPortletContext(), props);
        return props;
    }

    @Override
    public PortletContext setProperties(PortletContext portletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (portletContext == null) {
            throw new IllegalArgumentException("No null portlet id accepted");
        }
        if (changes == null) {
            throw new IllegalArgumentException("No null changes accepted");
        }
        for (PropertyChange change : changes) {
            if (change != null) continue;
            throw new IllegalArgumentException("No null change accepted");
        }
        String portletId = portletContext.getId();
        InternalContext context = this.getStateContext(portletContext);
        if (!context.isStateful()) {
            throw new InvalidPortletIdException("Cannot configure producer offered portlets", portletId);
        }
        StatefulContext statefulContext = (StatefulContext)context;
        Portlet referencedPortlet = super.getPortlet(context.getPortletContext());
        if (referencedPortlet == null) {
            throw new PortletInvokerException("The portlet " + context.getPortletContext() + " referenced by this clone " + portletId + " is not available");
        }
        PortletInfo referencedPortletInfo = referencedPortlet.getInfo();
        PreferencesInfo prefs = referencedPortletInfo.getPreferences();
        SimplePropertyMap properties = new SimplePropertyMap(statefulContext.getProperties());
        for (PropertyChange change : changes) {
            String key = change.getKey();
            int type = change.getType();
            PreferenceInfo pref = prefs.getPreference(key);
            if (pref != null && Boolean.TRUE.equals(pref.isReadOnly())) {
                type = 1;
            }
            if (type == 0) {
                properties.setProperty(key, change.getValue());
                continue;
            }
            properties.remove(key);
        }
        if (statefulContext.isLocal()) {
            LocalContext localContext = (LocalContext)statefulContext;
            String stateId = localContext.getStateId();
            try {
                this.persistenceManager.updateState(stateId, properties);
            }
            catch (NoSuchStateException e) {
                throw new NoSuchPortletException((Throwable)e, portletId);
            }
            catch (InvalidStateIdException e) {
                throw new InvalidPortletIdException((Throwable)e, portletId);
            }
            return PortletContext.createPortletContext((String)portletId);
        }
        RemoteContext remoteStatefulContext = (RemoteContext)statefulContext;
        return this.marshall(remoteStatefulContext.getStateType(), context.getPortletId(), properties);
    }

    @Override
    public PortletContext exportPortlet(PortletStateType stateType, PortletContext originalPortletContext) throws PortletInvokerException, IllegalArgumentException {
        if (originalPortletContext == null) {
            throw new IllegalArgumentException("No null portlet context accepted");
        }
        InternalContext context = this.getStateContext(originalPortletContext);
        String portletId = context.getPortletId();
        boolean persistLocally = this.stateManagementPolicy.persistLocally();
        if (context.isStateful()) {
            StatefulContext statefulContext = (StatefulContext)context;
            try {
                PortletState sstate = new PortletState(portletId, statefulContext.getProperties());
                Object marshalledState = this.stateConverter.marshall(stateType, sstate);
                return StatefulPortletContext.create((String)portletId, (PortletStateType)stateType, marshalledState);
            }
            catch (StateConversionException e) {
                throw new PortletInvokerException((Throwable)e);
            }
        }
        if (persistLocally) {
            SimplePropertyMap newState = new SimplePropertyMap();
            this.getPropertiesFromMetaData(originalPortletContext, newState);
            try {
                PortletState sstate = new PortletState(portletId, newState);
                Object marshalledState = this.stateConverter.marshall(stateType, sstate);
                return StatefulPortletContext.create((String)portletId, (PortletStateType)stateType, marshalledState);
            }
            catch (StateConversionException e) {
                throw new PortletInvokerException((Throwable)e);
            }
        }
        return this.getPortlet(originalPortletContext).getContext();
    }

    @Override
    public PortletContext importPortlet(PortletStateType stateType, PortletContext contextToImport) throws PortletInvokerException {
        if (contextToImport == null) {
            throw new IllegalArgumentException("No null portlet id accepted");
        }
        try {
            if (contextToImport instanceof StatefulPortletContext) {
                StatefulPortletContext statefulPortletContext = (StatefulPortletContext)contextToImport;
                Boolean persistLocally = this.stateManagementPolicy.persistLocally();
                PortletState portletState = this.getStateConverter().unmarshall(stateType, statefulPortletContext.getState());
                String originalPortletId = portletState.getPortletId();
                if (persistLocally.booleanValue()) {
                    String cloneStateId = this.persistenceManager.createState(originalPortletId, portletState.getProperties());
                    String cloneId = "_" + cloneStateId;
                    return PortletContext.createPortletContext((String)cloneId);
                }
                return this.marshall(stateType, originalPortletId, portletState.getProperties());
            }
            return this.getPortlet(contextToImport).getContext();
        }
        catch (StateConversionException e) {
            throw new PortletInvokerException((Throwable)e);
        }
    }

    private <S extends Serializable> PortletContext marshall(PortletStateType<S> stateType, String portletId, PropertyMap props) throws PortletInvokerException {
        try {
            PortletState sstate = new PortletState(portletId, props);
            S marshalledState = this.stateConverter.marshall(stateType, sstate);
            return StatefulPortletContext.create((String)"_dumbvalue", stateType, marshalledState);
        }
        catch (StateConversionException e) {
            throw new PortletInvokerException((Throwable)e);
        }
    }

    private void getPropertiesFromMetaData(PortletContext portletContext, PropertyMap props) throws PortletInvokerException {
        Portlet portlet = super.getPortlet(portletContext);
        PreferencesInfo prefs = portlet.getInfo().getPreferences();
        HashSet<String> keys = new HashSet<String>();
        for (String key : prefs.getKeys()) {
            PreferenceInfo pref = prefs.getPreference(key);
            if (!Boolean.TRUE.equals(pref.isReadOnly()) && props.keySet().contains(pref.getKey())) continue;
            keys.add(key);
        }
        PropertyMap refPreferencesInfo = super.getProperties(portletContext, keys);
        for (Map.Entry entry : refPreferencesInfo.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            props.setProperty(key, new ArrayList(value));
        }
    }

    private InternalContext getStateContext(PortletContext portletContext) throws NoSuchPortletException, InvalidPortletIdException {
        if (!(portletContext instanceof StatefulPortletContext)) {
            String portletId = portletContext.getId();
            if (portletContext.getId().startsWith("_")) {
                String stateId = portletId.substring("_".length());
                try {
                    PortletStateContext stateContext = this.persistenceManager.loadState(stateId);
                    return new LocalContext(stateContext.getState().getPortletId(), stateContext.getState().getProperties(), stateContext.getId());
                }
                catch (NoSuchStateException e) {
                    throw new NoSuchPortletException((Throwable)e, portletId);
                }
                catch (InvalidStateIdException e) {
                    throw new InvalidPortletIdException((Throwable)e, portletId);
                }
            }
            return new StatelessContext(portletContext.getId());
        }
        StatefulPortletContext statefulPortletContext = (StatefulPortletContext)portletContext;
        Serializable bytes = statefulPortletContext.getState();
        PortletStateType stateType = statefulPortletContext.getType();
        try {
            PortletState state = this.stateConverter.unmarshall(stateType, bytes);
            return new RemoteContext(stateType, state.getPortletId(), state.getProperties());
        }
        catch (StateConversionException e) {
            throw new InvalidPortletIdException((Throwable)e, portletContext.getId());
        }
    }

    private static abstract class InternalContext {
        private final String portletId;
        private final PortletContext portletContext;

        public abstract boolean isStateful();

        public InternalContext(String portletId) {
            if (portletId == null) {
                throw new IllegalArgumentException();
            }
            this.portletId = portletId;
            this.portletContext = PortletContext.createPortletContext((String)portletId);
        }

        public String getPortletId() {
            return this.portletId;
        }

        public PortletContext getPortletContext() {
            return this.portletContext;
        }
    }

    private static abstract class StatefulContext
    extends InternalContext {
        private final PropertyMap properties;

        protected StatefulContext(String portletId, PropertyMap properties) {
            super(portletId);
            if (properties == null) {
                throw new IllegalArgumentException();
            }
            this.properties = properties;
        }

        public abstract boolean isLocal();

        public PropertyMap getProperties() {
            return this.properties;
        }

        @Override
        public boolean isStateful() {
            return true;
        }
    }

    private static class LocalContext
    extends StatefulContext {
        private String stateId;

        public LocalContext(String portletId, PropertyMap state, String stateId) {
            super(portletId, state);
            if (stateId == null) {
                throw new IllegalArgumentException();
            }
            this.stateId = stateId;
        }

        public String getStateId() {
            return this.stateId;
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }

    private static class RemoteContext
    extends StatefulContext {
        private final PortletStateType stateType;

        public RemoteContext(PortletStateType stateType, String portletId, PropertyMap state) {
            super(portletId, state);
            this.stateType = stateType;
        }

        public PortletStateType getStateType() {
            return this.stateType;
        }

        @Override
        public boolean isLocal() {
            return false;
        }
    }

    private static class StatelessContext
    extends InternalContext {
        public StatelessContext(String portletId) {
            super(portletId);
        }

        @Override
        public boolean isStateful() {
            return false;
        }
    }
}

