/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.notification.plugin;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class DatePollNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(DatePollNotificationPlugin.class);
    private static final String AGENDA_DATE_POLL_NOTIFICATION_PLUGIN = "agenda.notification.plugin.key";
    private String notificationId;
    private IdentityManager identityManager;
    private AgendaCalendarService calendarService;
    private SpaceService spaceService;

    public DatePollNotificationPlugin(InitParams initParams, IdentityManager identityManager, AgendaCalendarService calendarService, SpaceService spaceService) {
        super(initParams);
        this.identityManager = identityManager;
        this.calendarService = calendarService;
        this.spaceService = spaceService;
        ValueParam notificationIdParam = initParams.getValueParam(AGENDA_DATE_POLL_NOTIFICATION_PLUGIN);
        if (notificationIdParam == null || StringUtils.isBlank((String)notificationIdParam.getValue())) {
            throw new IllegalStateException("'agenda.notification.plugin.key' parameter is mandatory");
        }
        this.notificationId = notificationIdParam.getValue();
    }

    public String getId() {
        return this.notificationId;
    }

    public boolean isValid(NotificationContext ctx) {
        if (NotificationUtils.getEventId(ctx) == 0L) {
            LOG.warn("Notification type '{}' isn't valid because the event wasn't found", new Object[]{this.getId()});
            return false;
        }
        return true;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        String typeModification;
        List eventAttendees = (List)ctx.value(NotificationUtils.EVENT_ATTENDEE);
        Event event = (Event)ctx.value(NotificationUtils.EVENT_AGENDA);
        Long modifierId = (Long)ctx.value(NotificationUtils.EVENT_MODIFIER);
        if (modifierId == null) {
            modifierId = event.getModifierId();
        }
        typeModification = StringUtils.isNotBlank((String)(typeModification = (String)ctx.value(NotificationUtils.EVENT_MODIFICATION_TYPE))) ? typeModification : AgendaEventModificationType.ADDED.name();
        Calendar calendar = this.calendarService.getCalendarById(event.getCalendarId());
        NotificationInfo notification = NotificationInfo.instance();
        notification.key(this.getId());
        if (event.getId() > 0L) {
            NotificationUtils.setNotificationRecipients(this.identityManager, notification, this.spaceService, eventAttendees, event, typeModification, modifierId);
        }
        if (notification.getSendToUserIds() == null || notification.getSendToUserIds().isEmpty()) {
            LOG.debug("Notification type '{}' doesn't have a recipient", new Object[]{this.getId()});
            return null;
        }
        NotificationUtils.storeEventParameters(this.identityManager, notification, event, calendar, typeModification);
        return notification.end();
    }
}

