/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.exceptions.ManagementException;

public class ManagementProviders {
    private ConcurrentMap<String, BindingProvider> bindingProviders = new ConcurrentHashMap<String, BindingProvider>();

    public void register(String componentName, BindingProvider bindingProvider) {
        BindingProvider bp = this.bindingProviders.putIfAbsent(componentName, bindingProvider);
        if (bp != null) {
            throw new ManagementException("Binding provider " + bp + " already registered for component " + componentName);
        }
    }

    public BindingProvider getBindingProvider(String componentName) {
        return (BindingProvider)this.bindingProviders.get(componentName);
    }
}

