/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.concurrent.TimeUnit;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;

public class RpcOptionsBuilder {
    private long timeout;
    private TimeUnit unit;
    private DeliverOrder deliverOrder;
    private ResponseFilter responseFilter;
    private ResponseMode responseMode;
    private boolean skipReplicationQueue;

    @Deprecated
    public RpcOptionsBuilder(long timeout, TimeUnit unit, ResponseMode responseMode, boolean fifoOrder) {
        this(timeout, unit, responseMode, fifoOrder ? DeliverOrder.PER_SENDER : DeliverOrder.NONE);
    }

    public RpcOptionsBuilder(long timeout, TimeUnit unit, ResponseMode responseMode, DeliverOrder deliverOrder) {
        this.timeout = timeout;
        this.unit = unit;
        this.deliverOrder = deliverOrder;
        this.responseFilter = null;
        this.responseMode = responseMode;
        this.skipReplicationQueue = false;
    }

    public RpcOptionsBuilder(RpcOptions template) {
        this.timeout = template.timeout();
        this.unit = template.timeUnit();
        this.deliverOrder = template.deliverOrder();
        this.responseFilter = template.responseFilter();
        this.responseMode = template.responseMode();
        this.skipReplicationQueue = template.skipReplicationQueue();
    }

    public RpcOptionsBuilder timeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
        return this;
    }

    public long timeout(TimeUnit outputTimeUnit) {
        return outputTimeUnit.convert(this.timeout, this.unit);
    }

    @Deprecated
    public RpcOptionsBuilder fifoOrder(boolean fifoOrder) {
        if (this.deliverOrder != DeliverOrder.TOTAL) {
            this.deliverOrder = fifoOrder ? DeliverOrder.PER_SENDER : DeliverOrder.NONE;
        }
        return this;
    }

    @Deprecated
    public RpcOptionsBuilder totalOrder(boolean totalOrder) {
        if (totalOrder) {
            this.deliverOrder = DeliverOrder.TOTAL;
        }
        return this;
    }

    public RpcOptionsBuilder deliverMode(DeliverOrder deliverOrder) {
        this.deliverOrder = deliverOrder;
        return this;
    }

    public RpcOptionsBuilder responseFilter(ResponseFilter responseFilter) {
        this.responseFilter = responseFilter;
        return this;
    }

    public RpcOptionsBuilder responseMode(ResponseMode responseMode) {
        this.responseMode = responseMode;
        return this;
    }

    public RpcOptionsBuilder skipReplicationQueue(boolean skipReplicationQueue) {
        this.skipReplicationQueue = skipReplicationQueue;
        return this;
    }

    public final RpcOptions build() {
        return new RpcOptions(this.timeout, this.unit, this.responseFilter, this.responseMode, this.skipReplicationQueue, this.deliverOrder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcOptionsBuilder that = (RpcOptionsBuilder)o;
        if (this.skipReplicationQueue != that.skipReplicationQueue) {
            return false;
        }
        if (this.timeout != that.timeout) {
            return false;
        }
        if (this.deliverOrder != that.deliverOrder) {
            return false;
        }
        if (this.responseFilter != null ? !this.responseFilter.equals(that.responseFilter) : that.responseFilter != null) {
            return false;
        }
        if (this.responseMode != that.responseMode) {
            return false;
        }
        return this.unit == that.unit;
    }

    public int hashCode() {
        int result = (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + this.unit.hashCode();
        result = 31 * result + this.deliverOrder.hashCode();
        result = 31 * result + (this.responseFilter != null ? this.responseFilter.hashCode() : 0);
        result = 31 * result + (this.responseMode != null ? this.responseMode.hashCode() : 0);
        result = 31 * result + (this.skipReplicationQueue ? 1 : 0);
        return result;
    }

    public String toString() {
        return "RpcOptionsBuilder{timeout=" + this.timeout + ", unit=" + (Object)((Object)this.unit) + ", deliverOrder=" + (Object)((Object)this.deliverOrder) + ", responseFilter=" + this.responseFilter + ", responseMode=" + (Object)((Object)this.responseMode) + ", skipReplicationQueue=" + this.skipReplicationQueue + '}';
    }
}

