/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.PathParamDescriptor;
import org.exoplatform.web.controller.metadata.RequestParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.metadata.RouteParamDescriptor;
import org.exoplatform.web.controller.router.EncodingMode;
import org.exoplatform.web.controller.router.MalformedRouteException;
import org.exoplatform.web.controller.router.Param;
import org.exoplatform.web.controller.router.Path;
import org.exoplatform.web.controller.router.PathParam;
import org.exoplatform.web.controller.router.PatternBuilder;
import org.exoplatform.web.controller.router.PatternRoute;
import org.exoplatform.web.controller.router.Regex;
import org.exoplatform.web.controller.router.RenderContext;
import org.exoplatform.web.controller.router.RequestParam;
import org.exoplatform.web.controller.router.RouteParam;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.SegmentRoute;
import org.exoplatform.web.controller.router.URIWriter;
import org.gatein.common.util.Tools;

class Route {
    private static final Route[] EMPTY_ROUTE_ARRAY = new Route[0];
    private static final RouteParam[] EMPTY_ROUTE_PARAM_ARRAY = new RouteParam[0];
    private static final RequestParam[] EMPTY_REQUEST_PARAM_ARRAY = new RequestParam[0];
    private final Router router;
    private Route parent;
    private boolean terminal;
    private Route[] children;
    private Map<QualifiedName, RouteParam> routeParamMap;
    private RouteParam[] routeParamArray;
    private Map<String, RequestParam> requestParamMap;
    private RequestParam[] requestParamArray;

    void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        if (this instanceof SegmentRoute) {
            writer.writeStartElement("segment");
            writer.writeAttribute("path", "/" + ((SegmentRoute)this).name);
            writer.writeAttribute("terminal", "" + this.terminal);
        } else if (this instanceof PatternRoute) {
            PatternRoute pr = (PatternRoute)this;
            StringBuilder path = new StringBuilder("/");
            for (int i = 0; i < pr.params.length; ++i) {
                path.append(pr.chunks[i]).append("{").append(pr.params[i].name.getValue()).append("}");
            }
            path.append(pr.chunks[pr.chunks.length - 1]);
            writer.writeStartElement("pattern");
            writer.writeAttribute("path", path.toString());
            writer.writeAttribute("terminal", Boolean.toString(this.terminal));
            for (PathParam param : pr.params) {
                writer.writeStartElement("path-param");
                writer.writeAttribute("qname", param.name.getValue());
                writer.writeAttribute("encodingMode", param.encodingMode.toString());
                writer.writeAttribute("pattern", param.matchingRegex.toString());
                writer.writeEndElement();
            }
        } else {
            writer.writeStartElement("route");
        }
        for (RouteParam routeParam : this.routeParamArray) {
            writer.writeStartElement("route-param");
            writer.writeAttribute("qname", routeParam.name.getValue());
            writer.writeAttribute("value", routeParam.value);
            writer.writeEndElement();
        }
        for (Param param : this.requestParamArray) {
            writer.writeStartElement("request-param");
            writer.writeAttribute("qname", ((RequestParam)param).name.getValue());
            writer.writeAttribute("name", ((RequestParam)param).matchName);
            if (((RequestParam)param).matchPattern != null) {
                writer.writeAttribute("value", ((RequestParam)param).matchPattern.getPattern());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public String toString() {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            StringWriter sw = new StringWriter();
            XMLStreamWriter xmlWriter = factory.createXMLStreamWriter(sw);
            this.writeTo(xmlWriter);
            return sw.toString();
        }
        catch (XMLStreamException e) {
            throw new AssertionError((Object)e);
        }
    }

    Route(Router router) {
        this.router = router;
        this.parent = null;
        this.terminal = true;
        this.children = EMPTY_ROUTE_ARRAY;
        this.routeParamMap = Collections.emptyMap();
        this.routeParamArray = EMPTY_ROUTE_PARAM_ARRAY;
        this.requestParamMap = Collections.emptyMap();
        this.requestParamArray = EMPTY_REQUEST_PARAM_ARRAY;
    }

    final boolean isTerminal() {
        return this.terminal;
    }

    final void render(RenderContext context, URIWriter writer) throws IOException {
        RouteMatch r = this.find(context);
        if (r != null) {
            r.render(writer);
        }
    }

    final RouteMatch find(RenderContext context) {
        context.enter();
        RouteMatch route = this._find(context);
        context.leave();
        return route;
    }

    private RouteMatch _find(RenderContext context) {
        RenderContext.Parameter entry;
        for (RouteParam routeParam : this.routeParamArray) {
            entry = context.getParameter(routeParam.name);
            if (entry == null || entry.isMatched() || !routeParam.value.equals(entry.getValue())) {
                return null;
            }
            entry.remove(entry.getValue());
        }
        block8: for (Param param : this.requestParamArray) {
            entry = context.getParameter(((RequestParam)param).name);
            boolean matched = false;
            if (entry != null && !entry.isMatched() && (((RequestParam)param).matchPattern == null || context.matcher(((RequestParam)param).matchPattern).matches(entry.getValue()))) {
                matched = true;
            }
            if (matched) {
                entry.remove(entry.getValue());
                continue;
            }
            switch (((RequestParam)param).controlMode) {
                case OPTIONAL: {
                    continue block8;
                }
                case REQUIRED: {
                    return null;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this instanceof PatternRoute) {
            PatternRoute prt = (PatternRoute)this;
            for (int i = 0; i < prt.params.length; ++i) {
                PathParam param = prt.params[i];
                RenderContext.Parameter parameter = context.getParameter(param.name);
                String matched = null;
                if (parameter != null && !parameter.isMatched()) {
                    block4 : switch (param.encodingMode) {
                        case FORM: 
                        case PRESERVE_PATH: {
                            for (int j = 0; j < param.matchingRegex.length; ++j) {
                                Regex renderingRegex = param.matchingRegex[j];
                                if (!context.matcher(renderingRegex).matches(parameter.getValue())) continue;
                                matched = param.templatePrefixes[j] + parameter.getValue() + param.templateSuffixes[j];
                                break block4;
                            }
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (matched == null) {
                    return null;
                }
                parameter.remove(matched);
            }
        }
        if (context.isEmpty() && this.terminal) {
            Map<QualifiedName, String> matches = Collections.emptyMap();
            for (QualifiedName name : context.getNames()) {
                RenderContext.Parameter parameter = context.getParameter(name);
                if (matches.isEmpty()) {
                    matches = new HashMap<QualifiedName, String>();
                }
                String match = parameter.getMatch();
                matches.put(name, match);
            }
            return new RouteMatch(context, this, matches);
        }
        for (Route route : this.children) {
            RouteMatch a = route.find(context);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    final RouteMatcher route(String path, Map<String, String[]> requestParams) {
        return new RouteMatcher(this, Path.parse(path), requestParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RouteFrame route(RouteFrame root, Map<String, String[]> requestParams) {
        RouteFrame current = root;
        if (root.status == RouteFrame.Status.MATCHED) {
            if (root.parent == null) return null;
            current = root.parent;
        } else if (root.status != RouteFrame.Status.BEGIN) {
            throw new AssertionError((Object)("Unexpected status " + root.status));
        }
        while (true) {
            if (current.status == RouteFrame.Status.BEGIN) {
                boolean matched = true;
                for (RequestParam requestParamDef : current.route.requestParamArray) {
                    String value = null;
                    String[] values = requestParams.get(requestParamDef.matchName);
                    if (values != null && values.length > 0 && values[0] != null) {
                        value = values[0];
                    }
                    if (value == null) {
                        switch (requestParamDef.controlMode) {
                            case OPTIONAL: {
                                break;
                            }
                            case REQUIRED: {
                                matched = false;
                            }
                        }
                    } else if (!requestParamDef.matchValue(value)) {
                        matched = false;
                        break;
                    }
                    switch (requestParamDef.valueMapping) {
                        case CANONICAL: {
                            break;
                        }
                        case NEVER_EMPTY: {
                            if (value == null || value.length() != 0) break;
                            value = null;
                            break;
                        }
                        case NEVER_NULL: {
                            if (value != null) break;
                            value = "";
                        }
                    }
                    if (value == null) continue;
                    if (current.matches == null) {
                        current.matches = new HashMap<QualifiedName, String>();
                    }
                    current.matches.put(requestParamDef.name, value);
                }
                if (matched) {
                    current.status = RouteFrame.Status.MATCHED_PARAMS;
                    continue;
                }
                current.status = RouteFrame.Status.END;
                continue;
            }
            if (current.status == RouteFrame.Status.MATCHED_PARAMS) {
                RouteFrame.Status next = current.path.length() > 0 && current.path.charAt(0) == '/' ? (current.path.length() == 1 && current.route.terminal ? RouteFrame.Status.MATCHED : RouteFrame.Status.PROCESS_CHILDREN) : RouteFrame.Status.END;
                current.status = next;
                continue;
            }
            if (current.status == RouteFrame.Status.PROCESS_CHILDREN) {
                if (current.childIndex < current.route.children.length) {
                    RouteFrame next;
                    Route child;
                    if ((child = current.route.children[current.childIndex++]) instanceof SegmentRoute) {
                        SegmentRoute segmentRoute = (SegmentRoute)child;
                        if (segmentRoute.name.length() == 0) {
                            next = new RouteFrame(current, segmentRoute, current.path);
                        } else {
                            String segment;
                            int pos = current.path.indexOf(47, 1);
                            if (pos == -1) {
                                pos = current.path.length();
                            }
                            if (segmentRoute.name.equals(segment = current.path.getValue().substring(1, pos))) {
                                Path nextSegmentPath = pos == current.path.length() ? Path.SLASH : current.path.subPath(pos);
                                next = new RouteFrame(current, segmentRoute, nextSegmentPath);
                            } else {
                                next = null;
                            }
                        }
                    } else {
                        if (!(child instanceof PatternRoute)) throw new AssertionError();
                        PatternRoute patternRoute = (PatternRoute)child;
                        Regex.Match[] matches = patternRoute.pattern.matcher().find(current.path.getValue());
                        if (matches.length > 0) {
                            Path nextPath;
                            int nextPos = matches[0].getEnd();
                            if (current.path.length() == nextPos) {
                                nextPath = Path.SLASH;
                            } else {
                                if (nextPos > 0 && current.path.charAt(nextPos - 1) == '/') {
                                    --nextPos;
                                }
                                nextPath = current.path.subPath(nextPos);
                            }
                            next = new RouteFrame(current, patternRoute, nextPath);
                            int index = 1;
                            for (int i = 0; i < patternRoute.params.length; ++i) {
                                PathParam param = patternRoute.params[i];
                                for (int j = 0; j < param.matchingRegex.length; ++j) {
                                    String value;
                                    Regex.Match match = matches[index + j];
                                    if (match.getEnd() == -1) continue;
                                    if (param.encodingMode == EncodingMode.FORM) {
                                        StringBuilder sb = new StringBuilder();
                                        for (int from = match.getStart(); from < match.getEnd(); ++from) {
                                            char c = current.path.charAt(from);
                                            if (c == child.router.separatorEscape && current.path.getRawLength(from) == 1) {
                                                c = '/';
                                            }
                                            sb.append(c);
                                        }
                                        value = sb.toString();
                                    } else {
                                        value = match.getValue();
                                    }
                                    if (next.matches == null) {
                                        next.matches = new HashMap<QualifiedName, String>();
                                    }
                                    next.matches.put(param.name, value);
                                    break;
                                }
                                index += param.matchingRegex.length;
                            }
                        } else {
                            next = null;
                        }
                    }
                    if (next == null) continue;
                    current = next;
                    continue;
                }
                current.status = RouteFrame.Status.END;
                continue;
            }
            if (current.status == RouteFrame.Status.MATCHED) return current;
            if (current.status != RouteFrame.Status.END) throw new AssertionError();
            if (current.parent == null) return current;
            current = current.parent;
        }
    }

    final <R extends Route> R add(R route) throws MalformedRouteException {
        if (route == null) {
            throw new NullPointerException("No null route accepted");
        }
        if (route.parent != null) {
            throw new IllegalArgumentException("No route with an existing parent can be accepted");
        }
        LinkedList<Param> ancestorParams = new LinkedList<Param>();
        this.findAncestorOrSelfParams(ancestorParams);
        LinkedList<Param> descendantParams = new LinkedList<Param>();
        for (Param param : ancestorParams) {
            route.findDescendantOrSelfParams(param.name, descendantParams);
            if (descendantParams.size() <= 0) continue;
            throw new MalformedRouteException("Duplicate parameter " + param.name);
        }
        if (!(route instanceof PatternRoute) && !(route instanceof SegmentRoute)) {
            throw new IllegalArgumentException("Only accept segment or pattern routes");
        }
        this.children = (Route[])Tools.appendTo((Object[])this.children, route);
        this.terminal = false;
        route.parent = this;
        return route;
    }

    final Set<String> getSegmentNames() {
        HashSet<String> names = new HashSet<String>();
        for (Route child : this.children) {
            if (!(child instanceof SegmentRoute)) continue;
            SegmentRoute childSegment = (SegmentRoute)child;
            names.add(childSegment.name);
        }
        return names;
    }

    final int getSegmentSize(String segmentName) {
        int size = 0;
        for (Route child : this.children) {
            if (!(child instanceof SegmentRoute)) continue;
            SegmentRoute childSegment = (SegmentRoute)child;
            if (!segmentName.equals(childSegment.name)) continue;
            ++size;
        }
        return size;
    }

    final SegmentRoute getSegment(String segmentName, int index) {
        for (Route child : this.children) {
            if (!(child instanceof SegmentRoute)) continue;
            SegmentRoute childSegment = (SegmentRoute)child;
            if (!segmentName.equals(childSegment.name)) continue;
            if (index == 0) {
                return childSegment;
            }
            --index;
        }
        return null;
    }

    final int getPatternSize() {
        int size = 0;
        for (Route route : this.children) {
            if (!(route instanceof PatternRoute)) continue;
            ++size;
        }
        return size;
    }

    final PatternRoute getPattern(int index) {
        for (Route route : this.children) {
            if (!(route instanceof PatternRoute)) continue;
            if (index == 0) {
                return (PatternRoute)route;
            }
            --index;
        }
        return null;
    }

    final Route append(RouteDescriptor descriptor) throws MalformedRouteException {
        Route route = this.append(descriptor.getPathParams(), descriptor.getPath());
        for (RouteParamDescriptor routeParamDesc : descriptor.getRouteParams()) {
            route.add(RouteParam.create(routeParamDesc));
        }
        for (RequestParamDescriptor requestParamDesc : descriptor.getRequestParams()) {
            route.add(RequestParam.create(requestParamDesc, this.router));
        }
        for (RouteDescriptor childDescriptor : descriptor.getChildren()) {
            route.append(childDescriptor);
        }
        return route;
    }

    final Route add(RouteParam param) throws MalformedRouteException {
        Param existing = this.findParam(param.name);
        if (existing != null) {
            throw new MalformedRouteException("Duplicate parameter " + param.name);
        }
        if (this.routeParamArray.length == 0) {
            this.routeParamMap = new HashMap<QualifiedName, RouteParam>();
        }
        this.routeParamMap.put(param.name, param);
        this.routeParamArray = (RouteParam[])Tools.appendTo((Object[])this.routeParamArray, (Object)param);
        return this;
    }

    final Route add(RequestParam param) throws MalformedRouteException {
        Param existing = this.findParam(param.name);
        if (existing != null) {
            throw new MalformedRouteException("Duplicate parameter " + param.name);
        }
        if (this.requestParamArray.length == 0) {
            this.requestParamMap = new HashMap<String, RequestParam>();
        }
        this.requestParamMap.put(param.matchName, param);
        this.requestParamArray = (RequestParam[])Tools.appendTo((Object[])this.requestParamArray, (Object)param);
        return this;
    }

    private Route append(Map<QualifiedName, PathParamDescriptor> pathParamDescriptors, String path) throws MalformedRouteException {
        Route next;
        if (path.length() == 0 || path.charAt(0) != '/') {
            throw new MalformedRouteException();
        }
        int pos = path.length();
        int level = 0;
        ArrayList<Integer> start = new ArrayList<Integer>();
        ArrayList<Integer> end = new ArrayList<Integer>();
        for (int i = 1; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '{') {
                if (level++ != 0) continue;
                start.add(i);
                continue;
            }
            if (c == '}') {
                if (--level != 0) continue;
                end.add(i);
                continue;
            }
            if (c != '/' || level != 0) continue;
            pos = i;
            break;
        }
        if (start.isEmpty()) {
            String segment = path.substring(1, pos);
            SegmentRoute route = new SegmentRoute(this.router, segment);
            this.add(route);
            next = route;
        } else if (start.size() == end.size()) {
            PatternBuilder builder = new PatternBuilder();
            builder.expr("^").expr('/');
            ArrayList<String> chunks = new ArrayList<String>();
            ArrayList<PathParam> parameterPatterns = new ArrayList<PathParam>();
            int previous = 1;
            for (int i = 0; i < start.size(); ++i) {
                builder.litteral(path, previous, (Integer)start.get(i));
                chunks.add(path.substring(previous, (Integer)start.get(i)));
                String parameterName = path.substring((Integer)start.get(i) + 1, (Integer)end.get(i));
                QualifiedName parameterQName = QualifiedName.parse(parameterName);
                PathParamDescriptor parameterDescriptor = pathParamDescriptors.get(parameterQName);
                PathParam param = parameterDescriptor != null ? PathParam.create(parameterDescriptor, this.router) : PathParam.create(parameterQName, this.router);
                builder.expr("(?:").expr(param.routingRegex).expr(")");
                parameterPatterns.add(param);
                previous = (Integer)end.get(i) + 1;
            }
            builder.litteral(path, previous, pos);
            builder.expr("(?:(?<=^/)|(?=/)|$)");
            chunks.add(path.substring(previous, pos));
            PatternRoute route = new PatternRoute(this.router, this.router.compile(builder.build()), parameterPatterns, chunks);
            this.add(route);
            next = route;
        } else {
            throw new UnsupportedOperationException("Report error");
        }
        if (pos < path.length()) {
            return next.append(pathParamDescriptors, path.substring(pos));
        }
        return next;
    }

    private Param getParam(QualifiedName name) {
        Param param = this.routeParamMap.get(name);
        if (param == null) {
            for (RequestParam requestParam : this.requestParamArray) {
                if (!requestParam.name.equals(name)) continue;
                param = requestParam;
                break;
            }
            if (param == null && this instanceof PatternRoute) {
                for (Param param2 : ((PatternRoute)this).params) {
                    if (!((PathParam)param2).name.equals(name)) continue;
                    param = param2;
                    break;
                }
            }
        }
        return param;
    }

    private Param findParam(QualifiedName name) {
        Param param = this.getParam(name);
        if (param == null && this.parent != null) {
            param = this.parent.findParam(name);
        }
        return param;
    }

    private void findParams(List<Param> params) {
        Collections.addAll(params, this.routeParamArray);
        for (RequestParam param : this.requestParamArray) {
            params.add(param);
        }
        if (this instanceof PatternRoute) {
            Collections.addAll(params, ((PatternRoute)this).params);
        }
    }

    private void findAncestorOrSelfParams(List<Param> params) {
        this.findParams(params);
        if (this.parent != null) {
            this.parent.findAncestorOrSelfParams(params);
        }
    }

    private void findDescendantOrSelfParams(QualifiedName name, List<Param> params) {
        Param param = this.getParam(name);
        if (param != null) {
            params.add(param);
        }
    }

    static class RouteMatch {
        final Route route;
        final Map<QualifiedName, String> matches;
        final RenderContext context;

        RouteMatch(RenderContext context, Route route, Map<QualifiedName, String> matches) {
            this.context = context;
            this.route = route;
            this.matches = matches;
        }

        private void render(URIWriter writer) throws IOException {
            this.renderPath(this.route, writer, false);
            this.renderQueryString(this.route, writer);
        }

        private boolean renderPath(Route route, URIWriter writer, boolean hasChildren) throws IOException {
            boolean endWithSlash = route.parent != null ? this.renderPath(route.parent, writer, true) : false;
            if (route instanceof SegmentRoute) {
                SegmentRoute sr = (SegmentRoute)route;
                if (!endWithSlash) {
                    writer.append('/');
                    endWithSlash = true;
                }
                String name = sr.encodedName;
                writer.append(name);
                if (name.length() > 0) {
                    endWithSlash = false;
                }
            } else if (route instanceof PatternRoute) {
                int i;
                PatternRoute pr = (PatternRoute)route;
                if (!endWithSlash) {
                    writer.append('/');
                    endWithSlash = true;
                }
                int count = 0;
                for (i = 0; i < pr.params.length; ++i) {
                    writer.append(pr.encodedChunks[i]);
                    count += pr.chunks[i].length();
                    PathParam def = pr.params[i];
                    String value = this.matches.get(def.name);
                    count += value.length();
                    int len = value.length();
                    for (int j = 0; j < len; ++j) {
                        char c = value.charAt(j);
                        if (c == route.router.separatorEscape) {
                            if (def.encodingMode == EncodingMode.PRESERVE_PATH) {
                                writer.append('_');
                                continue;
                            }
                            writer.append('%');
                            writer.append(route.router.separatorEscapeNible1);
                            writer.append(route.router.separatorEscapeNible2);
                            continue;
                        }
                        if (c == '/') {
                            writer.append(def.encodingMode == EncodingMode.PRESERVE_PATH ? (char)'/' : route.router.separatorEscape);
                            continue;
                        }
                        writer.appendSegment(c);
                    }
                }
                writer.append(pr.encodedChunks[i]);
                if ((count += pr.chunks[i].length()) > 0) {
                    endWithSlash = false;
                }
            } else if (!hasChildren) {
                writer.append('/');
                endWithSlash = true;
            }
            return endWithSlash;
        }

        private void renderQueryString(Route route, URIWriter writer) throws IOException {
            if (route.parent != null) {
                this.renderQueryString(route.parent, writer);
            }
            for (RequestParam requestParamDef : route.requestParamArray) {
                String s = this.matches.get(requestParamDef.name);
                switch (requestParamDef.valueMapping) {
                    case CANONICAL: {
                        break;
                    }
                    case NEVER_EMPTY: {
                        if (s == null || s.length() != 0) break;
                        s = null;
                        break;
                    }
                    case NEVER_NULL: {
                        if (s != null) break;
                        s = "";
                    }
                }
                if (s == null) continue;
                writer.appendQueryParameter(requestParamDef.matchName, s);
            }
        }
    }

    static class RouteMatcher
    implements Iterator<Map<QualifiedName, String>> {
        private final Map<String, String[]> requestParams;
        private RouteFrame frame;
        private RouteFrame next;

        RouteMatcher(Route route, Path path, Map<String, String[]> requestParams) {
            this.frame = new RouteFrame(route, path);
            this.requestParams = requestParams;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                if (this.frame != null) {
                    this.frame = Route.route(this.frame, this.requestParams);
                }
                if (this.frame != null && this.frame.status == RouteFrame.Status.MATCHED) {
                    this.next = this.frame;
                }
            }
            return this.next != null;
        }

        @Override
        public Map<QualifiedName, String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map<QualifiedName, String> parameters = this.next.getParameters();
            this.next = null;
            return parameters;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class RouteFrame {
        private final RouteFrame parent;
        private final Route route;
        private final Path path;
        private Status status;
        private Map<QualifiedName, String> matches;
        private int childIndex;

        private RouteFrame(RouteFrame parent, Route route, Path path) {
            this.parent = parent;
            this.route = route;
            this.path = path;
            this.status = Status.BEGIN;
            this.childIndex = 0;
        }

        private RouteFrame(Route route, Path path) {
            this(null, route, path);
        }

        Map<QualifiedName, String> getParameters() {
            Map<QualifiedName, String> parameters = null;
            RouteFrame frame = this;
            while (frame != null) {
                if (frame.matches != null) {
                    if (parameters == null) {
                        parameters = new HashMap<QualifiedName, String>();
                    }
                    parameters.putAll(frame.matches);
                }
                for (RouteParam param : frame.route.routeParamArray) {
                    if (parameters == null) {
                        parameters = new HashMap<QualifiedName, String>();
                    }
                    parameters.put(param.name, param.value);
                }
                frame = frame.parent;
            }
            return parameters != null ? parameters : Collections.emptyMap();
        }

        static enum Status {
            BEGIN,
            MATCHED_PARAMS,
            PROCESS_CHILDREN,
            MATCHED,
            END;

        }
    }
}

