/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupConfig;
import org.exoplatform.services.jcr.ext.backup.RepositoryChainLogPathHelper;
import org.exoplatform.services.jcr.ext.backup.server.RepositoryRestoreExeption;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class RepositoryBackupChainLog {
    protected static Log logger = ExoLogger.getLogger((String)"exo.jcr.component.ext.BackupChainLog");
    protected static String VERSION_LOG_1_1 = "1.1";
    public static final String PREFIX = "repository-backup-";
    private static final String SUFFIX = ".xml";
    private File log;
    private LogWriter logWriter;
    private LogReader logReader;
    private RepositoryBackupConfig config;
    private String backupId;
    private Calendar startedTime;
    private Calendar finishedTime;
    private boolean finalized;
    private List<String> workspaceBackupsInfo;
    private String workspaceSystem;
    private String fullBackupType;
    private String increnetalBackupType;
    private RepositoryEntry originalRepositoryEntry;
    private final String versionLog;

    public RepositoryBackupChainLog(File logDirectory, RepositoryBackupConfig config, String fullBackupType, String incrementalBackupType, String systemWorkspace, List<String> wsLogFilePathList, String backupId, Calendar startTime, RepositoryEntry rEntry, RepositoryServiceConfiguration repositoryServiceConfiguration) throws BackupOperationException {
        try {
            this.finalized = false;
            this.versionLog = VERSION_LOG_1_1;
            this.log = new File(PrivilegedFileHelper.getCanonicalPath((File)logDirectory) + File.separator + PREFIX + backupId + SUFFIX);
            PrivilegedFileHelper.createNewFile((File)this.log);
            this.backupId = backupId;
            this.config = config;
            this.startedTime = Calendar.getInstance();
            this.fullBackupType = fullBackupType;
            this.increnetalBackupType = incrementalBackupType;
            this.originalRepositoryEntry = rEntry;
            this.logWriter = new LogWriter(this.log);
            this.logWriter.write(config, fullBackupType, incrementalBackupType, logDirectory);
            this.logWriter.writeSystemWorkspaceName(systemWorkspace);
            this.logWriter.writeBackupsPath(wsLogFilePathList, config);
            this.logWriter.writeRepositoryEntry(rEntry, repositoryServiceConfiguration);
            this.workspaceBackupsInfo = wsLogFilePathList;
            this.workspaceSystem = systemWorkspace;
        }
        catch (IOException e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
        catch (XMLStreamException e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
        catch (FactoryConfigurationError e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
        catch (JiBXException e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
    }

    public RepositoryBackupChainLog(File log) throws BackupOperationException {
        this.log = log;
        this.backupId = log.getName().replaceAll(PREFIX, "").replaceAll(SUFFIX, "");
        try {
            this.logReader = new LogReader(log);
            this.logReader.readLogFile();
            this.versionLog = this.logReader.getVersionLog();
        }
        catch (FileNotFoundException e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + PrivilegedFileHelper.getAbsolutePath((File)log), e);
        }
        catch (XMLStreamException e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + PrivilegedFileHelper.getAbsolutePath((File)log), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + PrivilegedFileHelper.getAbsolutePath((File)log), e);
        }
        catch (Exception e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + PrivilegedFileHelper.getAbsolutePath((File)log), e);
        }
    }

    public String getLogFilePath() {
        return PrivilegedFileHelper.getAbsolutePath((File)this.log);
    }

    public RepositoryBackupConfig getBackupConfig() {
        return this.config;
    }

    public Calendar getStartedTime() {
        return this.startedTime;
    }

    public Calendar getFinishedTime() {
        return this.finishedTime;
    }

    public boolean isFinilized() {
        return this.finalized;
    }

    public synchronized void endLog() {
        if (!this.finalized) {
            this.finishedTime = Calendar.getInstance();
            this.finalized = true;
            this.logWriter.writeEndLog();
            try {
                FileInputStream in = PrivilegedFileHelper.fileInputStream((File)this.log);
                File dest = new File(this.config.getBackupDir() + File.separator + this.log.getName());
                if (!PrivilegedFileHelper.exists((File)dest)) {
                    FileOutputStream out = PrivilegedFileHelper.fileOutputStream((File)dest);
                    byte[] buf = new byte[(int)PrivilegedFileHelper.length((File)this.log)];
                    ((InputStream)in).read(buf);
                    String sConfig = new String(buf, "UTF-8");
                    sConfig = sConfig.replaceAll("<backup-dir>.+</backup-dir>", "<backup-dir>.</backup-dir>");
                    ((OutputStream)out).write(sConfig.getBytes("UTF-8"));
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
            }
            catch (PatternSyntaxException e) {
                logger.error((Object)"Can't write log", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"Can't write log", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"Can't write log", (Throwable)e);
            }
        }
    }

    public String getSystemWorkspace() {
        return this.workspaceSystem;
    }

    public List<String> getWorkspaceBackupsInfo() {
        return this.workspaceBackupsInfo;
    }

    public String getBackupId() {
        return this.backupId;
    }

    public RepositoryEntry getOriginalRepositoryEntry() {
        return this.originalRepositoryEntry;
    }

    private class LogWriter {
        protected Log logger = ExoLogger.getLogger((String)"exo.jcr.component.ext.LogWriter");
        private File logFile;
        XMLStreamWriter writer;

        public LogWriter(File file) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
            this.logFile = file;
            try {
                this.writer = (XMLStreamWriter)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<XMLStreamWriter>(){

                    @Override
                    public XMLStreamWriter run() throws Exception {
                        return XMLOutputFactory.newInstance().createXMLStreamWriter(new FileOutputStream(LogWriter.this.logFile), "UTF-8");
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof FileNotFoundException) {
                    throw (FileNotFoundException)cause;
                }
                if (cause instanceof XMLStreamException) {
                    throw (XMLStreamException)cause;
                }
                if (cause instanceof FactoryConfigurationError) {
                    throw (FactoryConfigurationError)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            this.writer.writeStartDocument();
            this.writer.writeStartElement("repository-backup-chain-log");
            this.writer.writeStartElement("version-log");
            this.writer.writeCharacters(RepositoryBackupChainLog.this.versionLog);
            this.writer.writeEndElement();
            this.writer.writeStartElement("start-time");
            this.writer.writeCharacters(JCRDateFormat.format((Calendar)RepositoryBackupChainLog.this.startedTime));
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public void writeSystemWorkspaceName(String wsName) throws XMLStreamException {
            this.writer.writeStartElement("system-workspace");
            this.writer.writeCharacters(wsName);
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public void writeBackupsPath(List<String> wsLogFilePathList, RepositoryBackupConfig config) throws XMLStreamException, IOException {
            this.writer.writeStartElement("workspaces-backup-info");
            for (String path : wsLogFilePathList) {
                this.writer.writeStartElement("url");
                this.writer.writeCharacters(RepositoryChainLogPathHelper.getRelativePath(path, PrivilegedFileHelper.getCanonicalPath((File)config.getBackupDir())));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public synchronized void write(RepositoryBackupConfig config, String fullBackupType, String incrementalBackupType, File serviceBackupDir) throws XMLStreamException, IOException {
            this.writer.writeStartElement("repository-backup-config");
            this.writer.writeStartElement("backup-type");
            this.writer.writeCharacters(String.valueOf(config.getBackupType()));
            this.writer.writeEndElement();
            this.writer.writeStartElement("full-backup-type");
            this.writer.writeCharacters(fullBackupType);
            this.writer.writeEndElement();
            this.writer.writeStartElement("incremental-backup-type");
            this.writer.writeCharacters(incrementalBackupType);
            this.writer.writeEndElement();
            if (config.getBackupDir() != null) {
                String serviceBackupDirPath;
                Object backupDir = PrivilegedFileHelper.getCanonicalPath((File)config.getBackupDir());
                if (((String)backupDir).startsWith(serviceBackupDirPath = PrivilegedFileHelper.getCanonicalPath((File)serviceBackupDir))) {
                    backupDir = "." + ((String)backupDir).replace(serviceBackupDirPath, "");
                    if (File.separator.equals("\\")) {
                        backupDir = ((String)backupDir).replaceAll("\\\\", "/");
                    }
                }
                this.writer.writeStartElement("backup-dir");
                this.writer.writeCharacters((String)backupDir);
                this.writer.writeEndElement();
            }
            if (config.getRepository() != null) {
                this.writer.writeStartElement("repository");
                this.writer.writeCharacters(config.getRepository());
                this.writer.writeEndElement();
            }
            this.writer.writeStartElement("incremental-job-period");
            this.writer.writeCharacters(Long.toString(config.getIncrementalJobPeriod()));
            this.writer.writeEndElement();
            this.writer.writeStartElement("incremental-job-number");
            this.writer.writeCharacters(Integer.toString(config.getIncrementalJobNumber()));
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public synchronized void writeEndLog() {
            try {
                this.writer.writeStartElement("finish-time");
                this.writer.writeCharacters(JCRDateFormat.format((Calendar)RepositoryBackupChainLog.this.finishedTime));
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
                this.writer.flush();
            }
            catch (XMLStreamException e) {
                this.logger.error((Object)"Can't write end log", (Throwable)e);
            }
        }

        public synchronized void writeRepositoryEntry(RepositoryEntry rEntry, RepositoryServiceConfiguration serviceConfiguration) throws XMLStreamException, IOException, JiBXException {
            IBindingFactory bfact;
            File config = new File(PrivilegedFileHelper.getCanonicalPath((File)RepositoryBackupChainLog.this.config.getBackupDir()) + File.separator + "original-repository-config.xml");
            PrivilegedFileHelper.createNewFile((File)config);
            FileOutputStream saveStream = PrivilegedFileHelper.fileOutputStream((File)config);
            ArrayList<RepositoryEntry> repositoryEntries = new ArrayList<RepositoryEntry>();
            repositoryEntries.add(rEntry);
            RepositoryServiceConfiguration newRepositoryServiceConfiguration = new RepositoryServiceConfiguration(serviceConfiguration.getDefaultRepositoryName(), repositoryEntries);
            try {
                bfact = (IBindingFactory)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<IBindingFactory>(){

                    @Override
                    public IBindingFactory run() throws Exception {
                        return BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof JiBXException) {
                    throw (JiBXException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.marshalDocument((Object)newRepositoryServiceConfiguration, "ISO-8859-1", null, (OutputStream)saveStream);
            ((OutputStream)saveStream).close();
            this.writer.writeStartElement("original-repository-config");
            this.writer.writeCharacters(config.getName());
            this.writer.writeEndElement();
        }
    }

    private class LogReader {
        protected Log logger = ExoLogger.getLogger((String)"exo.jcr.component.ext.LogReader");
        private File logFile;
        private XMLStreamReader reader;
        private String version;

        public LogReader(File logFile) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
            this.logFile = logFile;
            this.reader = XMLInputFactory.newInstance().createXMLStreamReader(PrivilegedFileHelper.fileInputStream((File)logFile), "UTF-8");
        }

        public void readLogFile() throws UnsupportedEncodingException, Exception {
            boolean endDocument = false;
            while (!endDocument) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("repository-backup-config")) {
                            RepositoryBackupChainLog.this.config = this.readBackupConfig();
                        }
                        if (name.equals("system-workspace")) {
                            RepositoryBackupChainLog.this.workspaceSystem = this.readContent();
                        }
                        if (name.equals("backup-config")) {
                            RepositoryBackupChainLog.this.config = this.readBackupConfig();
                        }
                        if (name.equals("workspaces-backup-info")) {
                            RepositoryBackupChainLog.this.workspaceBackupsInfo = this.readWorkspaceBackupInfo();
                        }
                        if (name.equals("start-time")) {
                            RepositoryBackupChainLog.this.startedTime = JCRDateFormat.parse((String)this.readContent());
                        }
                        if (name.equals("finish-time")) {
                            RepositoryBackupChainLog.this.finishedTime = JCRDateFormat.parse((String)this.readContent());
                        }
                        if (name.equals("original-repository-config")) {
                            RepositoryBackupChainLog.this.originalRepositoryEntry = this.readRepositoryEntry();
                        }
                        if (!name.equals("version-log")) break;
                        this.version = this.readContent();
                        break;
                    }
                    case 8: {
                        endDocument = true;
                    }
                }
            }
        }

        private RepositoryEntry readRepositoryEntry() throws UnsupportedEncodingException, Exception {
            IBindingFactory factory;
            String configName = this.readContent();
            File configFile = new File(PrivilegedFileHelper.getCanonicalPath((File)RepositoryBackupChainLog.this.getBackupConfig().getBackupDir()) + File.separator + configName);
            if (!PrivilegedFileHelper.exists((File)configFile)) {
                throw new RepositoryRestoreExeption("The backup set is not contains original repository configuration : " + PrivilegedFileHelper.getCanonicalPath((File)RepositoryBackupChainLog.this.getBackupConfig().getBackupDir()));
            }
            try {
                factory = (IBindingFactory)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<IBindingFactory>(){

                    @Override
                    public IBindingFactory run() throws Exception {
                        return BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof JiBXException) {
                    throw (JiBXException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            RepositoryServiceConfiguration conf = (RepositoryServiceConfiguration)uctx.unmarshalDocument((InputStream)PrivilegedFileHelper.fileInputStream((File)configFile), null);
            if (conf.getRepositoryConfigurations().size() != 1) {
                throw new RepositoryRestoreExeption("The oririginal configuration should be contains only one repository entry :" + PrivilegedFileHelper.getCanonicalPath((File)configFile));
            }
            if (!conf.getRepositoryConfiguration(RepositoryBackupChainLog.this.getBackupConfig().getRepository()).getName().equals(RepositoryBackupChainLog.this.getBackupConfig().getRepository())) {
                throw new RepositoryRestoreExeption("The oririginal configuration should be contains only one repository entry with name \"" + RepositoryBackupChainLog.this.getBackupConfig().getRepository() + "\" :" + PrivilegedFileHelper.getCanonicalPath((File)configFile));
            }
            return conf.getRepositoryConfiguration(RepositoryBackupChainLog.this.getBackupConfig().getRepository());
        }

        private List<String> readWorkspaceBackupInfo() throws XMLStreamException, IOException {
            ArrayList<String> wsBackupInfo = new ArrayList<String>();
            boolean endWorkspaceBackupInfo = false;
            while (!endWorkspaceBackupInfo) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (!name.equals("url")) break;
                        if (this.version != null && this.version.equals(VERSION_LOG_1_1)) {
                            String path = this.readContent();
                            wsBackupInfo.add(RepositoryChainLogPathHelper.getPath(path, PrivilegedFileHelper.getCanonicalPath((File)RepositoryBackupChainLog.this.config.getBackupDir())));
                            break;
                        }
                        wsBackupInfo.add(this.readContent());
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("workspaces-backup-info")) break;
                        endWorkspaceBackupInfo = true;
                    }
                }
            }
            return wsBackupInfo;
        }

        private BackupConfig readBackupConfig() throws XMLStreamException, IOException {
            BackupConfig conf = new BackupConfig();
            boolean endBackupConfig = false;
            while (!endBackupConfig) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("backup-dir")) {
                            if (this.version != null && this.version.equals(VERSION_LOG_1_1)) {
                                String dir = this.readContent();
                                if (dir.equals(".")) {
                                    path = PrivilegedFileHelper.getCanonicalPath((File)this.logFile.getParentFile());
                                    conf.setBackupDir(new File(path));
                                } else if (dir.startsWith("./")) {
                                    path = PrivilegedFileHelper.getCanonicalPath((File)this.logFile.getParentFile());
                                    dir = dir.replace("./", "/");
                                    if (File.separator.equals("\\")) {
                                        dir = dir.replaceAll("/", "\\\\");
                                    }
                                    conf.setBackupDir(new File(path + dir));
                                } else {
                                    conf.setBackupDir(new File(Deserializer.resolveVariables((String)dir)));
                                }
                            } else {
                                conf.setBackupDir(new File(this.readContent()));
                            }
                        }
                        if (name.equals("backup-type")) {
                            conf.setBackupType(Integer.valueOf(this.readContent()));
                        }
                        if (name.equals("repository")) {
                            conf.setRepository(this.readContent());
                        }
                        if (name.equals("workspace")) {
                            conf.setWorkspace(this.readContent());
                        }
                        if (name.equals("incremental-job-period")) {
                            conf.setIncrementalJobPeriod(Long.valueOf(this.readContent()));
                        }
                        if (name.equals("incremental-job-number")) {
                            conf.setIncrementalJobNumber(Integer.valueOf(this.readContent()));
                        }
                        if (name.equals("full-backup-type")) {
                            RepositoryBackupChainLog.this.fullBackupType = this.readContent();
                        }
                        if (!name.equals("incremental-backup-type")) break;
                        RepositoryBackupChainLog.this.increnetalBackupType = this.readContent();
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("repository-backup-config")) break;
                        endBackupConfig = true;
                    }
                }
            }
            return conf;
        }

        private String readContent() throws XMLStreamException {
            String content = null;
            int eventCode = this.reader.next();
            if (eventCode == 4) {
                content = this.reader.getText();
            }
            return content;
        }

        public String getVersionLog() {
            return this.version;
        }
    }
}

