/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.util.Classes;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public abstract class AbstractOperation
extends AbstractIdentifiedType
implements BiFunction<AbstractFeature, ParameterValueGroup, Object> {
    private static final long serialVersionUID = -179930765502963170L;
    static final String RESULT_PREFIX = "result.";

    public AbstractOperation(Map<String, ?> map) {
        super(map);
    }

    final Map<String, Object> resultIdentification(Map<String, ?> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(6);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string = entry.getKey();
            if (string == null || !string.startsWith(RESULT_PREFIX)) continue;
            hashMap.put(string.substring(RESULT_PREFIX.length()), entry.getValue());
        }
        if (hashMap.isEmpty()) {
            hashMap.put("name", super.getName());
            hashMap.put("definition", super.getDefinition());
            hashMap.put("designation", super.getDesignation());
            hashMap.put("description", super.getDescription());
        }
        return hashMap;
    }

    public abstract ParameterDescriptorGroup getParameters();

    public abstract AbstractIdentifiedType getResult();

    @Override
    public abstract Object apply(AbstractFeature var1, ParameterValueGroup var2);

    public Set<String> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.getParameters()) + Objects.hashCode(this.getResult());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            AbstractOperation abstractOperation = (AbstractOperation)object;
            return Objects.equals(this.getParameters(), abstractOperation.getParameters()) && Objects.equals(this.getResult(), abstractOperation.getResult());
        }
        return false;
    }

    public String toString() {
        AbstractIdentifiedType abstractIdentifiedType;
        StringBuilder stringBuilder = new StringBuilder(40).append(Classes.getShortClassName((Object)this)).append('[');
        GenericName genericName = this.getName();
        if (genericName != null) {
            stringBuilder.append('\u201c');
        }
        stringBuilder.append(genericName);
        if (genericName != null) {
            stringBuilder.append('\u201d');
        }
        if ((abstractIdentifiedType = this.getResult()) != null) {
            Object object = abstractIdentifiedType instanceof DefaultAttributeType ? Classes.getShortName(((DefaultAttributeType)abstractIdentifiedType).getValueClass()) : abstractIdentifiedType.getName();
            stringBuilder.append(" : ").append(object);
        }
        try {
            this.formatResultFormula(stringBuilder.append("] = "));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return stringBuilder.toString();
    }

    void formatResultFormula(Appendable appendable) throws IOException {
        AbstractOperation.defaultFormula(this.getParameters(), appendable);
    }

    static void defaultFormula(ParameterDescriptorGroup parameterDescriptorGroup, Appendable appendable) throws IOException {
        appendable.append(parameterDescriptorGroup != null ? AbstractOperation.name((Identifier)parameterDescriptorGroup.getName()) : "operation").append('(');
        if (parameterDescriptorGroup != null) {
            boolean bl = false;
            for (GeneralParameterDescriptor generalParameterDescriptor : parameterDescriptorGroup.descriptors()) {
                if (generalParameterDescriptor == null) continue;
                if (bl) {
                    appendable.append(", ");
                }
                appendable.append(AbstractOperation.name((Identifier)generalParameterDescriptor.getName()));
                bl = true;
            }
        }
        appendable.append(')');
    }

    private static String name(Identifier identifier) {
        return identifier != null ? identifier.getCode() : null;
    }
}

