/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.logging.Logger;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.image.SourceAlignedImage;
import org.apache.sis.image.Visualization;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class MaskImage
extends SourceAlignedImage {
    private MathTransform converter;

    MaskImage(ResampledImage resampledImage) {
        super(resampledImage, ColorModelFactory.createIndexColorModel(1, ImageUtilities.getVisibleBand(resampledImage), new int[]{0, -1}, true, 0));
        if (resampledImage.interpolation instanceof Visualization.InterpConvert) {
            try {
                this.converter = ((Visualization.InterpConvert)resampledImage.interpolation).converter.inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.raster"), ResampledImage.class, (String)"getProperty", (Throwable)noninvertibleTransformException);
            }
        }
    }

    @Override
    public Object getProperty(String string) {
        return POSITIONAL_PROPERTIES.contains(string) ? this.getSource().getProperty(string) : super.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return MaskImage.filterPropertyNames(this.getSource().getPropertyNames(), POSITIONAL_PROPERTIES, null);
    }

    @Override
    protected Raster computeTile(int n, int n2, WritableRaster writableRaster) throws TransformException {
        Raster raster = this.getSource().getTile(n, n2);
        writableRaster = this.createTile(n, n2);
        int n3 = writableRaster.getNumBands();
        int n4 = writableRaster.getMinX();
        int n5 = writableRaster.getMinY();
        int n6 = Math.addExact(n5, writableRaster.getHeight());
        int n7 = writableRaster.getWidth();
        float[] fArray = new float[Math.multiplyExact(n7, n3)];
        for (int i = n5; i < n6; ++i) {
            raster.getPixels(n4, i, n7, 1, fArray);
            if (this.converter != null) {
                this.converter.transform(fArray, 0, fArray, 0, n7);
            }
            for (int j = 0; j < fArray.length; ++j) {
                if (!Float.isNaN(fArray[j])) continue;
                int n8 = j / n3 + n4;
                writableRaster.setSample(n8, i, 0, 1);
            }
        }
        return writableRaster;
    }
}

