/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.lang.ref.Reference;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.collection.Cache;

final class TileCache
extends Cache<Key, Raster> {
    static final TileCache GLOBAL = new TileCache();

    private TileCache() {
        super(100, Runtime.getRuntime().maxMemory() / 4L, true);
    }

    protected int cost(Raster raster) {
        long l = (long)raster.getWidth() * (long)raster.getHeight() * (long)raster.getNumBands();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (dataBuffer != null) {
            try {
                l *= (long)DataBuffer.getDataTypeSize(dataBuffer.getDataType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l *= 32L;
            }
        }
        return Numerics.clamp((long)(l / 8L));
    }

    static final class Key {
        private final Reference<ComputedImage> image;
        private final int tileX;
        private final int tileY;

        Key(Reference<ComputedImage> reference, int n, int n2) {
            this.image = reference;
            this.tileX = n;
            this.tileY = n2;
        }

        final Point indices() {
            return new Point(this.tileX, this.tileY);
        }

        final String error(short s) {
            return Resources.format(s, this.tileX, this.tileY);
        }

        final void dispose() {
            GLOBAL.remove(this);
        }

        public int hashCode() {
            return System.identityHashCode(this.image) + this.tileX + 65563 * this.tileY;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.image == key.image && this.tileX == key.tileX && this.tileY == key.tileY;
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '[' + this.tileX + ", " + this.tileY + ']';
        }
    }
}

