/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.util.logging.Logging;

final class GeometryFactories {
    static final Geometries<?> implementation = GeometryFactories.link(GeometryFactories.link(GeometryFactories.link(null, "j2d"), "esri"), "jts");

    private GeometryFactories() {
    }

    private static Geometries<?> link(Geometries<?> geometries, String string) {
        Geometries geometries2;
        String string2 = JDK9.getPackageName(GeometryFactories.class) + '.' + string + ".Factory";
        try {
            geometries2 = (Geometries)Class.forName(string2).getField("INSTANCE").get(null);
        }
        catch (LinkageError | ReflectiveOperationException throwable) {
            LogRecord logRecord = Resources.forLocale(null).getLogRecord(Level.CONFIG, (short)56, string, throwable.toString());
            logRecord.setLoggerName("org.apache.sis.geometry");
            Logging.log(Geometries.class, (String)"register", (LogRecord)logRecord);
            return geometries;
        }
        geometries2.fallback = geometries;
        return geometries2;
    }
}

