/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.addons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.addons.AddOnPlugin;
import org.exoplatform.commons.addons.AddOnService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.pom.data.ApplicationData;

public class AddOnServiceImpl
implements AddOnService {
    private List<ApplicationDecorator<?>> apps = new ArrayList();

    @Override
    public List<Application<?>> getApplications(String containerName) {
        LinkedList apps = new LinkedList();
        for (ApplicationDecorator<?> app : this.apps) {
            if (!app.getContainerName().equals(containerName)) continue;
            apps.add(app.getApp());
        }
        return apps;
    }

    @Override
    public void addPlugin(AddOnPlugin plugin) {
        for (Application<?> app : plugin.getApplications()) {
            this.apps.add(new ApplicationDecorator(app, plugin.getPriority(), plugin.getContainerName()));
        }
        Collections.sort(this.apps, new Comparator<ApplicationDecorator<?>>(){

            @Override
            public int compare(ApplicationDecorator<?> o1, ApplicationDecorator<?> o2) {
                if (o1.getAppPriority() != o2.getAppPriority()) {
                    return o1.getAppPriority() - o2.getAppPriority();
                }
                TransientApplicationState s1 = (TransientApplicationState)o1.getApp().getState();
                TransientApplicationState s2 = (TransientApplicationState)o2.getApp().getState();
                return s1.getContentId().compareTo(s2.getContentId());
            }
        });
    }

    class ApplicationDecorator<T>
    extends Application<T> {
        private Application<T> app;
        private int appPriority;
        private String containerName;

        public ApplicationDecorator(ApplicationData<T> appData) {
            super(appData);
        }

        public ApplicationDecorator(Application<T> app, int priority, String containerName) {
            super(app.getType());
            this.app = app;
            this.appPriority = priority;
            this.containerName = containerName;
        }

        public Application<T> getApp() {
            return this.app;
        }

        public void setApp(Application<T> app) {
            this.app = app;
        }

        public int getAppPriority() {
            return this.appPriority;
        }

        public void setAppPriority(int appPriority) {
            this.appPriority = appPriority;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }
    }
}

