/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.jcr.Node;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui.UIPublicationPanel;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui.UIPublicationSchedule;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationHistory;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/webui/component/explorer/popup/action/UITabPane.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIPublicationContainer
extends org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationContainer {
    private DateFormat dateTimeFormater;

    public void initContainer(Node node) throws Exception {
        UIPublicationPanel publicationPanel = (UIPublicationPanel)this.addChild(UIPublicationPanel.class, null, null);
        publicationPanel.init(node);
        this.checkToShowPublicationScheduleAndPublicationHistory(node);
        this.setSelectedTab(1);
        Locale locale = Util.getPortalRequestContext().getLocale();
        this.dateTimeFormater = SimpleDateFormat.getDateTimeInstance(2, 2, locale);
    }

    private void checkToShowPublicationScheduleAndPublicationHistory(Node node) throws Exception {
        String currentState = node.getProperty("publication:currentState").getString();
        this.removeChild(UIPublicationSchedule.class);
        if ("staged".equals(currentState)) {
            UIPublicationSchedule publicationSchedule = (UIPublicationSchedule)this.addChild(UIPublicationSchedule.class, null, null);
            publicationSchedule.init(node);
            publicationSchedule.setRendered(false);
        }
        this.removeChild(UIPublicationHistory.class);
        UIPublicationHistory publicationHistory = (UIPublicationHistory)this.addChild(UIPublicationHistory.class, null, null);
        publicationHistory.init(node);
        publicationHistory.updateGrid();
        publicationHistory.setRendered(false);
    }

    public DateFormat getDateTimeFormater() {
        return this.dateTimeFormater;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Node currentNode = ((UIPublicationPanel)this.getChild(UIPublicationPanel.class)).getCurrentNode();
        this.checkToShowPublicationScheduleAndPublicationHistory(currentNode);
        super.processRender(context);
    }

    public static class CloseActionListener
    extends EventListener<UIPublicationContainer> {
        public void execute(Event<UIPublicationContainer> event) throws Exception {
            UIPublicationContainer publicationContainer = (UIPublicationContainer)((Object)event.getSource());
            UIPopupContainer uiPopupContainer = (UIPopupContainer)publicationContainer.getAncestorOfType(UIPopupContainer.class);
            uiPopupContainer.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }
}

