/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.util.logging.Level;

public class Logger {
    public static final Logger SYSTEM = new Logger(){

        @Override
        protected void send(Level level, CharSequence msg, Throwable t) {
            if (t != null) {
                System.err.println("[" + level.getName() + "] " + msg);
            } else {
                System.out.println("[" + level.getName() + "] " + msg);
            }
        }
    };
    public static final String FORMAT = "%1$tH:%1$tM,%1$tS:%1$tL %2$-7s [%3$s]: %4$s";

    protected void send(Level level, CharSequence msg, Throwable t) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void log(Level level, CharSequence msg) {
        this.log(level, msg, null);
    }

    public void log(Level level, CharSequence msg, Throwable t) {
        switch (level.intValue()) {
            case 1000: {
                this.error(msg, t);
                break;
            }
            case 900: {
                this.warning(msg, t);
                break;
            }
            case 800: {
                this.info(msg, t);
                break;
            }
            case 700: {
                this.error(msg, t);
                break;
            }
            case 500: {
                this.debug(msg, t);
                break;
            }
            case 400: {
                this.debug(msg, t);
                break;
            }
            case 300: {
                this.trace(msg, t);
            }
        }
    }

    public void error(CharSequence msg) {
        this.error(msg, null);
    }

    public void error(CharSequence msg, Throwable t) {
        this.send(Level.SEVERE, msg, t);
    }

    public void warning(CharSequence msg) {
        this.warning(msg, null);
    }

    public void warning(CharSequence msg, Throwable t) {
        this.send(Level.WARNING, msg, t);
    }

    public void info(CharSequence msg) {
        this.info(msg, null);
    }

    public void info(CharSequence msg, Throwable t) {
        this.send(Level.INFO, msg, t);
    }

    public void debug(CharSequence msg) {
        this.debug(msg, null);
    }

    public void debug(CharSequence msg, Throwable t) {
        this.send(Level.FINER, msg, t);
    }

    public void trace(CharSequence msg) {
        this.trace(msg, null);
    }

    public void trace(CharSequence msg, Throwable t) {
        this.send(Level.FINEST, msg, t);
    }
}

