/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi.weld;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import juzu.impl.fs.Visitor;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.spi.cdi.weld.WeldContainer;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.resources.ClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;

class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private final WeldContainer owner;
    private final String id;
    private final Collection<String> beanClasses;
    private final BeansXml xml;
    private final ServiceRegistry registry;

    BeanDeploymentArchiveImpl(WeldContainer owner, String id, List<ReadFileSystem<?>> fileSystems) throws IOException {
        ArrayList<URL> xmlURLs = new ArrayList<URL>();
        final StringBuilder buffer = new StringBuilder();
        final ArrayList<String> beanClasses = new ArrayList<String>();
        for (ReadFileSystem<?> fileSystem : fileSystems) {
            fileSystem.traverse(new Visitor.Default(){

                @Override
                public void enterDir(Object dir, String name) throws IOException {
                    if (name.length() > 0) {
                        buffer.append(name).append('.');
                    }
                }

                @Override
                public void file(Object file, String name) throws IOException {
                    if (name.endsWith(".class")) {
                        int len = name.length() - ".class".length();
                        buffer.append(name, 0, len);
                        String fqn = buffer.toString();
                        buffer.setLength(buffer.length() - len);
                        if (!fqn.startsWith("juzu.impl.inject.spi.guice.") && !fqn.startsWith("juzu.impl.inject.spi.spring.")) {
                            beanClasses.add(fqn);
                        }
                    }
                }

                @Override
                public void leaveDir(Object dir, String name) throws IOException {
                    if (name.length() > 0) {
                        buffer.setLength(buffer.length() - name.length() - 1);
                    }
                }
            });
            Object beansPath = fileSystem.getPath(Arrays.asList("META-INF", "beans.xml"));
            if (beansPath == null) continue;
            xmlURLs.add(fileSystem.getURL(beansPath));
        }
        BeansXml xml = owner.bootstrap.parse(xmlURLs);
        ClassLoaderResourceLoader loader = new ClassLoaderResourceLoader(owner.classLoader);
        SimpleServiceRegistry registry = new SimpleServiceRegistry();
        registry.add(ResourceLoader.class, (Service)loader);
        this.beanClasses = beanClasses;
        this.xml = xml;
        this.id = id;
        this.registry = registry;
        this.owner = owner;
    }

    public ClassLoader getClassLoader() {
        return this.owner.classLoader;
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.emptyList();
    }

    public Collection<String> getBeanClasses() {
        return this.beanClasses;
    }

    public BeansXml getBeansXml() {
        return this.xml;
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return Collections.emptyList();
    }

    public ServiceRegistry getServices() {
        return this.registry;
    }

    public String getId() {
        return this.id;
    }
}

