/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.router.metamodel;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import juzu.Param;
import juzu.Route;
import juzu.impl.common.JSON;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.controller.metamodel.ControllerMetaModel;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.controller.metamodel.HandlerMetaModel;
import juzu.impl.plugin.controller.metamodel.ParameterMetaModel;
import juzu.impl.plugin.controller.metamodel.PhaseParameterMetaModel;
import juzu.impl.plugin.router.ParamDescriptor;
import juzu.impl.plugin.router.metamodel.RouteMetaModel;
import juzu.impl.plugin.router.metamodel.RouterMetaModel;

public class RouterApplicationMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public RouterApplicationMetaModelPlugin() {
        super("router");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Route.class);
    }

    private RouterMetaModel getRoutes(ApplicationMetaModel metaModel, boolean create) {
        RouterMetaModel routes = metaModel.getChild(RouterMetaModel.KEY);
        if (routes == null && create) {
            routes = new RouterMetaModel();
            metaModel.addChild(RouterMetaModel.KEY, routes);
        }
        return routes;
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        if (key.getElement() instanceof ElementHandle.Method) {
            this.getRoutes((ApplicationMetaModel)metaModel, (boolean)true).annotations.put(key.getElement(), added);
        }
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        if (key.getElement() instanceof ElementHandle.Method) {
            this.getRoutes((ApplicationMetaModel)metaModel, (boolean)true).annotations.remove(key.getElement());
        }
    }

    @Override
    public void postProcessEvents(ApplicationMetaModel metaModel) {
        RouterMetaModel router = this.getRoutes(metaModel, false);
        if (router != null) {
            router.routes.clear();
            ControllersMetaModel controllers = metaModel.getChild(ControllersMetaModel.KEY);
            if (controllers != null) {
                for (ControllerMetaModel controller : controllers) {
                    for (HandlerMetaModel method : controller) {
                        AnnotationState annotation = router.annotations.get(method.getMethod());
                        if (annotation == null) continue;
                        String path = (String)annotation.get("value");
                        Integer priority = (Integer)annotation.get("priority");
                        HashMap<String, ParamDescriptor> parameters = null;
                        ExecutableElement exe = metaModel.processingContext.get(method.getMethod());
                        for (VariableElement variableElement : exe.getParameters()) {
                            String name;
                            ParameterMetaModel a;
                            Param param = variableElement.getAnnotation(Param.class);
                            if (param == null) continue;
                            if (parameters == null) {
                                parameters = new HashMap<String, ParamDescriptor>();
                            }
                            if ((a = method.parameterBy(name = variableElement.getSimpleName().toString())) instanceof PhaseParameterMetaModel) {
                                PhaseParameterMetaModel b = (PhaseParameterMetaModel)a;
                                String pattern = param.pattern().length() == 0 ? null : param.pattern();
                                parameters.put(b.getMappedName(), new ParamDescriptor(pattern, param.preservePath(), param.captureGroup()));
                                continue;
                            }
                            throw new UnsupportedOperationException("Handle me gracefully");
                        }
                        String handle = method.getMethod().getMethodHandle().toString();
                        RouteMetaModel routeMetaModel = new RouteMetaModel(path, handle, priority != null ? priority : 0, parameters);
                        router.routes.add(routeMetaModel);
                    }
                }
            }
        }
    }

    @Override
    public JSON getDescriptor(ApplicationMetaModel application) {
        RouterMetaModel router = this.getRoutes(application, false);
        if (router != null) {
            ArrayList<RouteMetaModel> list = new ArrayList<RouteMetaModel>(router.routes);
            Collections.sort(list, new Comparator<RouteMetaModel>(){

                @Override
                public int compare(RouteMetaModel o1, RouteMetaModel o2) {
                    return Integer.valueOf(o1.priority).compareTo(o2.priority);
                }
            });
            return new JSON().map("routes", list);
        }
        return null;
    }
}

