/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.ar;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ar.ArchiveURLStreamHandler;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class Archive {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.Archive");
    private static final ArchiveURLStreamHandler HANDLER = new ArchiveURLStreamHandler();
    public static final String PROTOCOL = "ar";
    public static final Archive WAR = new Archive("war", false, true, null);
    public static final Archive EAR = new Archive("ear", false, true, Collections.singleton(WAR));
    private final String type;
    private final boolean useDirWoExt;
    private final boolean allowsDir;
    private final Set<Archive> subArchives;

    public Archive(String type, boolean useDirWoExt, boolean allowsDir, Set<Archive> subArchives) {
        this.type = type;
        this.useDirWoExt = useDirWoExt;
        this.allowsDir = allowsDir;
        this.subArchives = subArchives;
    }

    public String getType() {
        return this.type;
    }

    public boolean isUseDirWoExt() {
        return this.useDirWoExt;
    }

    public boolean isAllowsDir() {
        return this.allowsDir;
    }

    public Set<Archive> getSubArchives() {
        return this.subArchives;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Archive other = (Archive)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "Archive [type=" + this.type + ", useDirWoExt=" + this.useDirWoExt + ", allowsDir=" + this.allowsDir + ", subArchives=" + this.subArchives + "]";
    }

    public static Collection<URL> getConfigurationURL(List<String> appDeployDirectories, Set<Archive> appDeployArchives, String configuration) throws IOException {
        if (configuration == null || configuration.isEmpty()) {
            throw new IllegalArgumentException("The path to the configuration cannot be empty");
        }
        if (appDeployDirectories == null || appDeployDirectories.isEmpty() || appDeployArchives == null || appDeployArchives.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        for (String directory : appDeployDirectories) {
            File dir = new File(directory);
            if (!dir.exists()) {
                LOG.debug("The directory {} doesn't exist", new Object[]{directory});
                continue;
            }
            result.addAll(Archive.getConfigurationURL(dir, appDeployArchives, configuration, true));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<URL> getConfigurationURL(File dir, final Set<Archive> appDeployArchives, String configuration, final boolean enableRecursion) throws IOException {
        final HashMap<String, Archive> types = new HashMap<String, Archive>();
        for (Archive archive : appDeployArchives) {
            types.put(archive.getType(), archive);
        }
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        Object[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File f;
                Archive extension = null;
                int index = name.lastIndexOf(46);
                if (index != -1) {
                    String ext = name.substring(index + 1).toLowerCase();
                    extension = (Archive)types.get(ext);
                }
                if ((f = new File(dir, name)).isDirectory()) {
                    if (extension == null) {
                        if (!enableRecursion) {
                            return false;
                        }
                        for (Archive archive : appDeployArchives) {
                            if (!archive.isUseDirWoExt()) continue;
                            return true;
                        }
                    } else if (extension.isAllowsDir()) {
                        return true;
                    }
                } else if (extension != null) {
                    if (!extension.isUseDirWoExt()) {
                        return true;
                    }
                    File file = new File(dir, name.substring(0, name.length() - extension.getType().length() - 1));
                    return !file.exists() || !file.isDirectory();
                }
                return false;
            }
        });
        Arrays.sort(files);
        for (Object file : files) {
            Object f;
            if (((File)file).isDirectory()) {
                f = new File((File)file, configuration);
                if (((File)f).exists() && ((File)f).isFile()) {
                    result.add(Archive.parse(((File)f).getAbsolutePath()));
                    continue;
                }
                int index = ((File)file).getName().lastIndexOf(46);
                Archive extension = null;
                if (index == -1) {
                    if (!enableRecursion) continue;
                    for (Archive archive : appDeployArchives) {
                        if (!archive.isUseDirWoExt()) continue;
                        extension = archive;
                        break;
                    }
                } else {
                    String ext = ((File)file).getName().substring(index + 1).toLowerCase();
                    extension = (Archive)types.get(ext);
                }
                if (extension == null || extension.getSubArchives() == null || extension.getSubArchives().isEmpty()) continue;
                result.addAll(Archive.getConfigurationURL((File)file, extension.getSubArchives(), configuration, false));
                continue;
            }
            f = new ZipFile((File)file);
            try {
                ZipEntry entry = ((ZipFile)f).getEntry(configuration);
                if (entry != null && ((ZipFile)f).getEntry(configuration + "/") == null) {
                    result.add(Archive.parse(((File)file).getAbsolutePath() + "!/" + configuration));
                    continue;
                }
                int indexExt = ((File)file).getName().lastIndexOf(46);
                if (indexExt == -1) {
                    throw new IllegalStateException("Cannot find the extension of the file " + ((File)file).getAbsolutePath());
                }
                String extFile = ((File)file).getName().substring(indexExt + 1).toLowerCase();
                if (extFile == null) {
                    throw new IllegalStateException("Cannot find the extension of the file " + ((File)file).getAbsolutePath());
                }
                Archive extension = (Archive)types.get(extFile);
                if (extension == null) {
                    throw new IllegalStateException("Cannot find the archive corresponding to the file " + ((File)file).getAbsolutePath());
                }
                if (extension.getSubArchives() == null || extension.getSubArchives().isEmpty()) continue;
                HashMap<String, Archive> subTypes = new HashMap<String, Archive>();
                for (Archive archive : extension.getSubArchives()) {
                    subTypes.put(archive.getType(), archive);
                }
                Enumeration<? extends ZipEntry> entries = ((ZipFile)f).entries();
                TreeMap<String, Archive> names = new TreeMap<String, Archive>();
                while (entries.hasMoreElements()) {
                    String ext;
                    ZipEntry ze = entries.nextElement();
                    String name = ze.getName();
                    int index = name.indexOf(47);
                    if (index > 0) {
                        if (index < name.length() - 1) continue;
                        name = name.substring(0, index);
                    }
                    if ((index = name.lastIndexOf(46)) == -1) {
                        // empty if block
                    }
                    if (!subTypes.containsKey(ext = name.substring(index + 1).toLowerCase())) continue;
                    names.put(ze.getName(), (Archive)subTypes.get(ext));
                }
                block22: for (String name : names.keySet()) {
                    Archive a = (Archive)names.get(name);
                    ZipEntry ze = ((ZipFile)f).getEntry(name);
                    if (ze.isDirectory()) {
                        if (!a.isAllowsDir() || (ze = ((ZipFile)f).getEntry(name + configuration)) == null || ((ZipFile)f).getEntry(name + configuration + "/") != null) continue;
                        result.add(Archive.parse(((File)file).getAbsolutePath() + "!/" + name + configuration));
                        continue;
                    }
                    ZipInputStream zis = new ZipInputStream(((ZipFile)f).getInputStream(ze));
                    try {
                        ZipEntry subZP;
                        while ((subZP = zis.getNextEntry()) != null) {
                            if (subZP.isDirectory() || !subZP.getName().equals(configuration)) continue;
                            result.add(Archive.parse(((File)file).getAbsolutePath() + "!/" + name + "!/" + configuration));
                            continue block22;
                        }
                    }
                    finally {
                        try {
                            zis.close();
                        }
                        catch (IOException e) {
                            LOG.debug((Object)"Could not close the zip input stream");
                        }
                    }
                }
            }
            finally {
                try {
                    ((ZipFile)f).close();
                }
                catch (IOException e) {
                    LOG.debug((Object)"Could not close the zip file");
                }
            }
        }
        return result;
    }

    public static URL createArchiveURL(String url) throws MalformedURLException {
        url = Deserializer.resolveVariables(url);
        final String sUrl = url = url.replace('\\', '/');
        return (URL)SecurityHelper.doPrivilegedMalformedURLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

            @Override
            public URL run() throws Exception {
                return new URL(null, sUrl, HANDLER);
            }
        });
    }

    public static boolean isArchiveURL(String url) {
        return url.startsWith("ar:");
    }

    static URL parse(String path2Convert) throws MalformedURLException {
        if (File.separatorChar != '/') {
            path2Convert = ((String)path2Convert).replace(File.separatorChar, '/');
        }
        if (!((String)path2Convert).startsWith("/")) {
            path2Convert = "/" + (String)path2Convert;
        }
        return new URL(PROTOCOL, null, -1, (String)path2Convert, HANDLER);
    }
}

