/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.xml;

import java.util.Map;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;

public class Deserializer {
    public static final String EXO_CONTAINER_PROP_NAME = "container.name.suffix";
    public static final String PORTAL_CONTAINER_VARIABLE_PREFIX = "portal.container.";

    public static String resolveString(String s) {
        return Deserializer.resolveNClean(s);
    }

    public static Boolean resolveBoolean(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        if ((s = Deserializer.resolveNClean(s)).equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Cannot accept boolean value " + s);
    }

    public static Integer resolveInteger(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        s = Deserializer.resolveNClean(s);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot accept integer value " + s, e);
        }
    }

    public static Long resolveLong(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        s = Deserializer.resolveNClean(s);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot accept integer value " + s, e);
        }
    }

    public static Double resolveDouble(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        s = Deserializer.resolveNClean(s);
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot accept integer value " + s, e);
        }
    }

    public static String resolveVariables(String input) {
        return Deserializer.resolveVariables(input, null);
    }

    public static String resolveVariables(String input, Map<String, Object> props) {
        boolean NORMAL = false;
        boolean SEEN_DOLLAR = true;
        int IN_BRACKET = 2;
        if (input == null) {
            return input;
        }
        char[] chars = input.toCharArray();
        StringBuilder buffer = new StringBuilder();
        boolean properties = false;
        int state = 0;
        int start = 0;
        boolean precedingBackslash = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != 2) {
                state = 1;
            } else if (c == '{' && state == 1 && !precedingBackslash) {
                buffer.append(input.substring(start, i - 1));
                state = 2;
                start = i - 1;
            } else if (state == 1) {
                state = 0;
            } else if (c == '}' && state == 2 && !precedingBackslash) {
                if (start + 2 == i) {
                    buffer.append("${}");
                } else {
                    String value = null;
                    String key = input.substring(start + 2, i);
                    String defaultValue = null;
                    int index = key.indexOf(58);
                    if (index > -1) {
                        defaultValue = key.substring(index + 1);
                        if (defaultValue != null && !defaultValue.isEmpty()) {
                            defaultValue = defaultValue.replace("\\{", "{").replace("\\}", "}");
                        }
                        key = key.substring(0, index);
                    }
                    if (key.equals(EXO_CONTAINER_PROP_NAME)) {
                        container = ExoContainerContext.getCurrentContainerIfPresent();
                        if (container instanceof PortalContainer) {
                            RootContainer rootContainer = (RootContainer)ExoContainerContext.getTopContainer();
                            value = rootContainer.isPortalContainerConfigAware() ? "_" + container.getContext().getName() : "";
                        }
                    } else if (key.startsWith(PORTAL_CONTAINER_VARIABLE_PREFIX)) {
                        container = ExoContainerContext.getCurrentContainerIfPresent();
                        if (container instanceof PortalContainer) {
                            Object oValue = ((PortalContainer)container).getSetting(key.substring(PORTAL_CONTAINER_VARIABLE_PREFIX.length()));
                            value = oValue == null ? null : oValue.toString();
                        }
                    } else {
                        if (props != null) {
                            Object oValue = props.get(key);
                            String string = value = oValue == null ? null : oValue.toString();
                        }
                        if (value == null) {
                            value = PrivilegedSystemHelper.getProperty((String)key);
                        }
                    }
                    if (value == null && defaultValue != null) {
                        value = defaultValue;
                    }
                    if (value != null) {
                        properties = true;
                        buffer.append(value);
                    }
                }
                start = i + 1;
                state = 0;
            }
            precedingBackslash = c == '\\' ? !precedingBackslash : false;
        }
        if (!properties) {
            return input;
        }
        if (start != chars.length) {
            buffer.append(input.substring(start, chars.length));
        }
        return buffer.toString();
    }

    public static String cleanString(String s) {
        return s == null ? null : s.trim();
    }

    public static String resolveNClean(String s) {
        return Deserializer.cleanString(Deserializer.resolveVariables(s));
    }
}

