/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.resolver;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletContext;
import org.exoplatform.resolver.ResourceKey;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortletResourceResolver
extends ResourceResolver {
    protected static Log log = ExoLogger.getLogger(PortletResourceResolver.class);
    private PortletContext pcontext_;
    private String scheme_;

    public PortletResourceResolver(PortletContext context, String scheme) {
        this.pcontext_ = context;
        this.scheme_ = scheme;
    }

    @Override
    public URL getResource(String url) throws Exception {
        String path = this.removeScheme(url);
        return this.pcontext_.getResource(path);
    }

    @Override
    public InputStream getInputStream(String url) throws Exception {
        String path = this.removeScheme(url);
        return this.pcontext_.getResourceAsStream(path);
    }

    @Override
    public List<URL> getResources(String url) throws Exception {
        ArrayList<URL> urlList = new ArrayList<URL>();
        urlList.add(this.getResource(url));
        return urlList;
    }

    @Override
    public List<InputStream> getInputStreams(String url) throws Exception {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        inputStreams.add(this.getInputStream(url));
        return inputStreams;
    }

    @Override
    public String getRealPath(String url) {
        String path = this.removeScheme(url);
        return this.pcontext_.getRealPath(path);
    }

    @Override
    public boolean isModified(String url, long lastAccess) {
        try {
            URL uri = this.getResource(url);
            URLConnection con = uri.openConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)(url + ": " + con.getLastModified() + " " + lastAccess));
            }
            if (con.getLastModified() > lastAccess) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public String getWebAccessPath(String url) {
        return "/" + this.pcontext_.getPortletContextName() + this.removeScheme(url);
    }

    @Override
    public String getResourceScheme() {
        return this.scheme_;
    }

    @Override
    public ResourceKey createResourceKey(String url) {
        String portletContextName = this.pcontext_.getPortletContextName();
        int resolverId = portletContextName != null ? portletContextName.hashCode() : this.hashCode();
        return new ResourceKey(resolverId, url);
    }
}

