/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.xml.stax.writer.builder;

import org.gatein.common.xml.stax.writer.builder.StaxFormatterBuilder;
import org.gatein.common.xml.stax.writer.formatting.SimpleFormatter;
import org.gatein.common.xml.stax.writer.formatting.XmlStreamingFormatter;

public class StaxFormatterBuilderImpl
implements StaxFormatterBuilder {
    private Character indentCharacter;
    private Integer indentSize;
    private String newline;

    @Override
    public StaxFormatterBuilder withIndentCharacter(char indentCharacter) {
        this.indentCharacter = Character.valueOf(indentCharacter);
        return this;
    }

    @Override
    public StaxFormatterBuilder ofIndentSize(int indentSize) {
        this.indentSize = indentSize;
        return this;
    }

    @Override
    public StaxFormatterBuilder withNewline(String newline) {
        this.newline = newline;
        return this;
    }

    @Override
    public XmlStreamingFormatter build() {
        if (this.indentCharacter == null) {
            throw new IllegalStateException("indent character is required value for this builder.");
        }
        if (this.indentSize == null) {
            throw new IllegalArgumentException("indent size is a required value for this builder.");
        }
        if (this.newline == null) {
            throw new IllegalArgumentException("newline is a required value for this builder.");
        }
        return new SimpleFormatter(this.indentCharacter.charValue(), this.indentSize, this.newline);
    }
}

