/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.liquibase;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;

public class DropHSQLDBUniqueConstraint
implements CustomTaskChange {
    private String tableName;
    private String uniqueColumns;

    public String getConfirmationMessage() {
        return "Unique constraint for table '" + this.tableName + "' and unique columns '" + this.uniqueColumns + "' dropped";
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public void execute(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        try {
            connection.attached(database);
            CallableStatement statement = connection.prepareCall("SELECT CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'UNIQUE' AND TABLE_NAME = '" + this.tableName + "'");
            ResultSet indexResults = statement.executeQuery();
            if (!indexResults.next()) {
                return;
            }
            String constraintName = indexResults.getString(1);
            CallableStatement dropConstraintQuery = connection.prepareCall("ALTER TABLE " + this.tableName + " DROP CONSTRAINT " + constraintName);
            dropConstraintQuery.execute();
            CallableStatement hsqldbCheckpointQuery = connection.prepareCall("CHECKPOINT");
            hsqldbCheckpointQuery.execute();
            connection.commit();
        }
        catch (Exception e) {
            throw new CustomChangeException("Error dropping constraint of table " + this.tableName + "for unique columns " + this.uniqueColumns, (Throwable)e);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getUniqueColumns() {
        return this.uniqueColumns;
    }

    public void setUniqueColumns(String uniqueColumns) {
        this.uniqueColumns = uniqueColumns;
    }
}

