/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.plugin;

import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;

public class AgendaGuestUserIdentityProvider
extends IdentityProvider<InternetAddress> {
    public static final String NAME = "GUEST_USER";

    public String getName() {
        return NAME;
    }

    public InternetAddress findByRemoteId(String remoteId) {
        return AgendaGuestUserIdentityProvider.getInternetAddress(remoteId);
    }

    public Identity createIdentity(InternetAddress emailAdress) {
        if (emailAdress == null || StringUtils.isBlank((String)emailAdress.getAddress())) {
            return null;
        }
        String email = emailAdress.getAddress().toLowerCase();
        return new Identity(NAME, email);
    }

    public void populateProfile(Profile profile, InternetAddress emailAdress) {
        profile.setProperty("email", (Object)emailAdress.getAddress().toLowerCase());
        profile.setProperty("fullName", (Object)emailAdress.getAddress().toLowerCase());
    }

    private static InternetAddress getInternetAddress(String remoteId) {
        InternetAddress[] addresses = null;
        try {
            addresses = InternetAddress.parse((String)remoteId);
        }
        catch (Exception e) {
            return null;
        }
        if (addresses == null || addresses.length != 1) {
            return null;
        }
        return addresses[0];
    }
}

