/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.rest.model.CalendarEntity;
import org.exoplatform.agenda.rest.model.CalendarList;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.util.RestEntityBuilder;
import org.exoplatform.agenda.util.RestUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/v1/agenda/calendars")
@Tag(name="/v1/agenda/calendars", description="Manages agenda calendars associated to users and spaces")
public class AgendaCalendarRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(AgendaCalendarRest.class);
    private AgendaCalendarService agendaCalendarService;
    private IdentityManager identityManager;

    public AgendaCalendarRest(AgendaCalendarService agendaCalendarService, IdentityManager identityManager) {
        this.agendaCalendarService = agendaCalendarService;
        this.identityManager = identityManager;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of calendars", description="Retrieves the list of calendars available for an owner of type user or space, identitifed by its identity technical identifier. If no designated owner, all calendars available for authenticated user will be retrieved.", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response list(@Parameter(description="Limit of calendar owner identity ids to incluse in results") @QueryParam(value="ownerIds") List<Long> ownerIds, @Parameter(description="Whether return size of results or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Offset of result") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit of result") @Schema(defaultValue="10") @QueryParam(value="limit") int limit) {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        if (limit <= 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        try {
            List calendars = null;
            calendars = ownerIds == null || ownerIds.isEmpty() ? this.agendaCalendarService.getCalendars(offset, limit, currentUser) : this.agendaCalendarService.getCalendarsByOwnerIds(ownerIds, currentUser);
            CalendarList calendarList = new CalendarList();
            if (ownerIds != null && !ownerIds.isEmpty()) {
                for (Long ownerId : ownerIds) {
                    boolean calendarNotFound = calendars.stream().noneMatch(calendar -> calendar.getOwnerId() == ownerId.longValue());
                    if (!calendarNotFound) continue;
                    long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
                    Calendar calendar2 = this.agendaCalendarService.createCalendarInstance(ownerId.longValue(), userIdentityId);
                    calendars.add(calendar2);
                }
            } else if (returnSize && !calendars.isEmpty()) {
                int returnedCalendarSize = calendars.size();
                if (returnedCalendarSize >= limit) {
                    int calendarCount = this.agendaCalendarService.countCalendars(currentUser);
                    calendarList.setSize(calendarCount);
                } else {
                    calendarList.setSize(returnedCalendarSize);
                }
            }
            List calendarEntities = calendars.stream().map(calendar -> RestEntityBuilder.fromCalendar(this.identityManager, calendar)).collect(Collectors.toList());
            calendarList.setCalendars(calendarEntities);
            return Response.ok((Object)calendarList).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized calendar with owner Ids '{}'", new Object[]{currentUser, ownerIds, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of calendars", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{calendarId}")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves a calendar identified by its technical identifier", description="Retrieves a calendar identified by its technical identifier", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCalendarById(@Parameter(description="Calendar technical identifier", required=true) @PathParam(value="calendarId") long calendarId) {
        if (calendarId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Calendar identifier must be a positive integer").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        try {
            Calendar calendar = this.agendaCalendarService.getCalendarById(calendarId, currentUser);
            if (calendar == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)RestEntityBuilder.fromCalendar(this.identityManager, calendar)).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized calendar with Id '{}'", new Object[]{currentUser, calendarId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving a calendar with id '{}'", new Object[]{calendarId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a new calendar", description="Creates a new calendar", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createCalendar(@Parameter(description="Calendar object to create", required=true) CalendarEntity calendarEntity) {
        if (calendarEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Calendar object is mandatory").build();
        }
        if (calendarEntity.getOwner() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Calendar owner is mandatory").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        try {
            this.agendaCalendarService.createCalendar(RestEntityBuilder.toCalendar(calendarEntity), currentUser);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to create a calendar for owner '{}'", new Object[]{currentUser, calendarEntity.getOwner(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating a calendar", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates an existing calendar", description="Updates an existing calendar", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateCalendar(@Parameter(description="Calendar object to update", required=true) CalendarEntity calendarEntity) {
        if (calendarEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Calendar object is mandatory").build();
        }
        if (calendarEntity.getId() <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Calendar technical identifier must be positive").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        try {
            this.agendaCalendarService.updateCalendar(RestEntityBuilder.toCalendar(calendarEntity), currentUser);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to update a not existing calendar '{}'", new Object[]{currentUser, calendarEntity.getOwner(), e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Calendar not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to update a calendar for owner '{}'", new Object[]{currentUser, calendarEntity.getOwner(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating a calendar", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes an existing calendar", description="Deletes an existing calendar", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteCalendar(@Parameter(description="Calendar technical identifier", required=true) @PathParam(value="calendarId") long calendarId) {
        if (calendarId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Calendar technical identifier must be positive").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        try {
            this.agendaCalendarService.deleteCalendarById(calendarId, currentUser);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to delete a not existing calendar '{}'", new Object[]{currentUser, calendarId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Calendar not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to deletes a non authorized calendar", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error deleting a calendar", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

