/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import org.apache.sis.geometry.ArrayEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImmutableEnvelope
extends ArrayEnvelope
implements Serializable {
    private static final long serialVersionUID = 8740224085449107870L;

    public ImmutableEnvelope(DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        super(directPosition, directPosition2);
    }

    public ImmutableEnvelope(double[] dArray, double[] dArray2, CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        super(dArray, dArray2);
        this.crs = coordinateReferenceSystem;
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.getDimension(), (CoordinateReferenceSystem)coordinateReferenceSystem);
    }

    public ImmutableEnvelope(GeographicBoundingBox geographicBoundingBox) {
        super(geographicBoundingBox);
    }

    public ImmutableEnvelope(Envelope envelope) {
        super(envelope);
    }

    public ImmutableEnvelope(CoordinateReferenceSystem coordinateReferenceSystem, Envelope envelope) throws MismatchedDimensionException {
        super(envelope);
        this.crs = coordinateReferenceSystem;
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.getDimension(), (CoordinateReferenceSystem)coordinateReferenceSystem);
    }

    public ImmutableEnvelope(CoordinateReferenceSystem coordinateReferenceSystem, CharSequence charSequence) throws IllegalArgumentException, MismatchedDimensionException {
        super(charSequence);
        this.crs = coordinateReferenceSystem;
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.getDimension(), (CoordinateReferenceSystem)coordinateReferenceSystem);
    }

    public static ImmutableEnvelope castOrCopy(Envelope envelope) {
        if (envelope == null || envelope instanceof ImmutableEnvelope) {
            return (ImmutableEnvelope)envelope;
        }
        return new ImmutableEnvelope(envelope);
    }
}

