/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.NamedIdentifier;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;

@XmlType(name="CodeType")
public final class Code {
    @XmlValue
    String code;
    @XmlAttribute
    String codeSpace;

    Code() {
    }

    Code(ReferenceIdentifier referenceIdentifier) {
        this.code = referenceIdentifier.getCode();
        this.codeSpace = referenceIdentifier.getCodeSpace();
        String string = referenceIdentifier.getVersion();
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.codeSpace != null) {
                stringBuilder.append(this.codeSpace);
            }
            this.codeSpace = stringBuilder.append(':').append(string).toString();
        }
    }

    public ReferenceIdentifier getIdentifier() {
        String string = this.code;
        if (string == null) {
            return null;
        }
        Object object = null;
        String string2 = null;
        String string3 = this.codeSpace;
        DefinitionURI definitionURI = DefinitionURI.parse((String)string);
        if (definitionURI != null && definitionURI.code != null) {
            object = Identifiers.isEPSG((String)string3, (String)definitionURI.authority) ? Citations.EPSG : Citations.fromName((String)string3);
            string3 = definitionURI.authority;
            string2 = definitionURI.version;
            string = definitionURI.code;
        } else if (string3 != null) {
            int n = string3.lastIndexOf(58);
            if (n >= 0) {
                string2 = string3.substring(n + 1);
                string3 = string3.substring(0, n);
            }
            object = Citations.fromName((String)string3);
        }
        return new NamedIdentifier((Citation)object, string3, (CharSequence)string, string2, null);
    }

    public static Code forIdentifiedObject(Class<?> clazz, Iterable<? extends ReferenceIdentifier> iterable) {
        if (iterable != null) {
            String string;
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            Object object2 = null;
            Object object3 = iterable.iterator();
            while (object3.hasNext()) {
                object = object3.next();
                string = object.getCode();
                if (string == null) continue;
                if (string.regionMatches(true, 0, "urn:", 0, 4)) {
                    return new Code((ReferenceIdentifier)object);
                }
                if (bl) continue;
                bl = string.regionMatches(true, 0, "http:", 0, 5);
                if (bl) {
                    object2 = object;
                    continue;
                }
                if (bl2 || !(bl2 = "EPSG".equalsIgnoreCase(object.getCodeSpace())) && object2 != null) continue;
                object2 = object;
            }
            if (object2 != null) {
                if (!bl && (object3 = NameMeaning.toURN(clazz, (String)object2.getCodeSpace(), (String)object2.getVersion(), (String)object2.getCode())) != null) {
                    object = new Code();
                    string = object2.getAuthority();
                    if (bl2) {
                        object.codeSpace = "IOGP";
                        if (string != null) {
                            for (Identifier identifier : string.getIdentifiers()) {
                                String string2;
                                if (!"EPSG".equalsIgnoreCase(identifier.getCode()) || !(identifier instanceof ReferenceIdentifier) || (string2 = ((ReferenceIdentifier)identifier).getCodeSpace()) == null) continue;
                                object.codeSpace = string2;
                                break;
                            }
                        }
                    } else {
                        object.codeSpace = Citations.toCodeSpace((Citation)string);
                    }
                    object.code = object3;
                    return object;
                }
                return new Code((ReferenceIdentifier)object2);
            }
        }
        return null;
    }
}

