/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.io.TableAppender;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

public class Tile
implements Serializable {
    private static final long serialVersionUID = 1638238437701248681L;
    private int x;
    private int y;
    private int width;
    private int height;
    private int xSubsampling;
    private int ySubsampling;
    private AffineTransform gridToCRS;

    public Tile(Point point, Dimension dimension) {
        ArgumentChecks.ensureNonNull((String)"location", (Object)point);
        this.x = point.x;
        this.y = point.y;
        this.setSubsampling(dimension);
    }

    public Tile(Rectangle rectangle, Dimension dimension) {
        ArgumentChecks.ensureNonNull((String)"location", (Object)rectangle);
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        if (this.width <= 0 || this.height <= 0) {
            throw new IllegalArgumentException(Errors.format((short)29, (Object)"region"));
        }
        this.setSubsampling(dimension);
    }

    public Tile(Rectangle rectangle, AffineTransform affineTransform) {
        ArgumentChecks.ensureNonNull((String)"gridToCRS", (Object)affineTransform);
        if (rectangle != null) {
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = Math.max(rectangle.width, 0);
            this.height = Math.max(rectangle.height, 0);
        }
        this.gridToCRS = new AffineTransform(affineTransform);
    }

    Tile(AffineTransform affineTransform, Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        this.gridToCRS = affineTransform;
        this.setSubsampling(null);
    }

    private void ensureDefined() throws IllegalStateException {
        if (this.xSubsampling == 0 || this.ySubsampling == 0) {
            throw new IllegalStateException();
        }
    }

    public synchronized Point getLocation() throws IllegalStateException {
        this.ensureDefined();
        return new Point(this.x, this.y);
    }

    public synchronized Dimension getSize() throws IOException {
        if ((this.width | this.height) == 0) {
            Dimension dimension = this.fetchSize();
            this.width = dimension.width;
            this.height = dimension.height;
        }
        return new Dimension(this.width, this.height);
    }

    protected Dimension fetchSize() throws IOException {
        throw new IllegalStateException();
    }

    public synchronized Rectangle getRegion() throws IllegalStateException, IOException {
        this.ensureDefined();
        if ((this.width | this.height) == 0) {
            Dimension dimension = this.fetchSize();
            this.width = dimension.width;
            this.height = dimension.height;
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getRegionOnFinestLevel() throws IOException {
        int n;
        int n2;
        Rectangle rectangle;
        Tile tile = this;
        synchronized (tile) {
            rectangle = this.getRegion();
            n2 = this.xSubsampling;
            n = this.ySubsampling;
        }
        rectangle.x = Math.multiplyExact(rectangle.x, n2);
        rectangle.y = Math.multiplyExact(rectangle.y, n);
        rectangle.width = Math.multiplyExact(rectangle.width, n2);
        rectangle.height = Math.multiplyExact(rectangle.height, n);
        return rectangle;
    }

    final void setRegionOnFinestLevel(Rectangle rectangle) throws ArithmeticException {
        assert (Thread.holdsLock(this));
        int n = this.xSubsampling;
        int n2 = this.ySubsampling;
        assert (rectangle.width % n == 0 && rectangle.height % n2 == 0) : rectangle;
        this.x = rectangle.x / n;
        this.y = rectangle.y / n2;
        this.width = rectangle.width / n;
        this.height = rectangle.height / n2;
    }

    public synchronized Dimension getSubsampling() throws IllegalStateException {
        this.ensureDefined();
        return new Dimension(this.xSubsampling, this.ySubsampling);
    }

    final void setSubsampling(Dimension dimension) throws IllegalStateException {
        if ((this.xSubsampling | this.ySubsampling) != 0) {
            throw new IllegalStateException();
        }
        if (dimension != null) {
            ArgumentChecks.ensureBetween((String)"width", (int)0, (int)65535, (int)dimension.width);
            ArgumentChecks.ensureBetween((String)"height", (int)0, (int)65535, (int)dimension.height);
            this.xSubsampling = dimension.width;
            this.ySubsampling = dimension.height;
        } else {
            this.ySubsampling = 1;
            this.xSubsampling = 1;
        }
    }

    final synchronized AffineTransform getPendingGridToCRS() {
        if ((this.xSubsampling | this.ySubsampling) != 0) {
            return null;
        }
        AffineTransform affineTransform = this.gridToCRS;
        this.gridToCRS = null;
        return affineTransform;
    }

    public synchronized AffineTransform2D getGridToCRS() throws IllegalStateException {
        this.ensureDefined();
        return (AffineTransform2D)this.gridToCRS;
    }

    final void setGridToCRS(AffineTransform affineTransform) throws IllegalStateException {
        assert (Thread.holdsLock(this));
        if (this.gridToCRS == null) {
            this.gridToCRS = affineTransform;
        } else if (!this.gridToCRS.equals(affineTransform)) {
            throw new IllegalStateException();
        }
    }

    final void translate(int n, int n2) {
        assert (Thread.holdsLock(this));
        this.x = Math.addExact(this.x, n);
        this.y = Math.addExact(this.y, n2);
        this.gridToCRS = null;
    }

    public Optional<String> getName(boolean bl) {
        return Optional.empty();
    }

    public int getImageIndex() {
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)this)).append('[');
        if ((this.xSubsampling | this.ySubsampling) != 0) {
            Cloneable cloneable;
            stringBuilder.append("location=(");
            if (this.width == 0 && this.height == 0) {
                cloneable = this.getLocation();
                stringBuilder.append(((Point)cloneable).x).append(',').append(((Point)cloneable).y);
            } else {
                try {
                    cloneable = this.getRegion();
                    stringBuilder.append(cloneable.x).append(',').append(cloneable.y).append("), size=(").append(cloneable.width).append(',').append(cloneable.height);
                }
                catch (IOException iOException) {
                    stringBuilder.append(iOException);
                }
            }
            cloneable = this.getSubsampling();
            stringBuilder.append("), subsampling=(").append(((Dimension)cloneable).width).append(',').append(((Dimension)cloneable).height).append(')');
        } else if ((this.width != 0 || this.height != 0) && this.getClass() == Tile.class) {
            stringBuilder.append("size=(").append(this.width).append(',').append(this.height).append(')');
        }
        return stringBuilder.append(']').toString();
    }

    static String toString(Collection<Tile> collection, int n) {
        StringWriter stringWriter = new StringWriter();
        try {
            Tile.writeTable(collection, stringWriter, n);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringWriter.toString();
    }

    public static void writeTable(Collection<Tile> collection, Writer writer, int n) throws IOException {
        int n2 = n;
        TableAppender tableAppender = new TableAppender((Appendable)writer);
        tableAppender.setMultiLinesCells(false);
        tableAppender.nextLine('\u2550');
        tableAppender.append((CharSequence)"Format\tInput\tindex\tx\ty\twidth\theight\tdx\tdy\n");
        tableAppender.nextLine('\u2500');
        tableAppender.setMultiLinesCells(true);
        for (Tile tile : collection) {
            if (--n2 < 0) break;
            tableAppender.setCellAlignment((byte)-1);
            tile.getName(false).ifPresent(arg_0 -> ((TableAppender)tableAppender).append(arg_0));
            tableAppender.nextColumn();
            tile.getName(true).ifPresent(arg_0 -> ((TableAppender)tableAppender).append(arg_0));
            tableAppender.nextColumn();
            tableAppender.setCellAlignment((byte)1);
            tableAppender.append((CharSequence)String.valueOf(tile.getImageIndex()));
            tableAppender.nextColumn();
            int n3 = tile.x;
            int n4 = tile.y;
            int n5 = tile.width;
            int n6 = tile.height;
            int n7 = tile.xSubsampling;
            int n8 = tile.ySubsampling;
            try {
                Dimension dimension = tile.getSubsampling();
                n7 = dimension.width;
                n8 = dimension.height;
                try {
                    Rectangle rectangle = tile.getRegion();
                    n3 = rectangle.x;
                    n4 = rectangle.y;
                    n5 = rectangle.width;
                    n6 = rectangle.height;
                }
                catch (IOException iOException) {
                    n5 = 0;
                    n6 = 0;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            tableAppender.append((CharSequence)String.valueOf(n3));
            tableAppender.nextColumn();
            tableAppender.append((CharSequence)String.valueOf(n4));
            if ((n5 | n6) != 0) {
                tableAppender.nextColumn();
                tableAppender.append((CharSequence)String.valueOf(n5));
                tableAppender.nextColumn();
                tableAppender.append((CharSequence)String.valueOf(n6));
            } else {
                tableAppender.nextColumn();
                tableAppender.nextColumn();
            }
            if ((n7 | n8) != 0) {
                tableAppender.nextColumn();
                tableAppender.append((CharSequence)String.valueOf(n7));
                tableAppender.nextColumn();
                tableAppender.append((CharSequence)String.valueOf(n8));
            }
            tableAppender.nextLine();
        }
        tableAppender.nextLine('\u2550');
        tableAppender.flush();
        if (n2 < 0) {
            writer.write(Vocabulary.getResources((Locale)null).getString((short)137, (Object)(collection.size() - n)));
            writer.write(System.lineSeparator());
        }
    }
}

