/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.IdentifiedObjectSet;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.FactoryException;

final class CoordinateOperationSet
extends IdentifiedObjectSet<CoordinateOperation> {
    private final Map<String, Integer> projections = new HashMap<String, Integer>();

    CoordinateOperationSet(AuthorityFactory authorityFactory) {
        super(authorityFactory, CoordinateOperation.class);
    }

    final void addAuthorityCode(String string, Integer n) {
        if (n != null) {
            this.projections.put(string, n);
        }
        this.addAuthorityCode(string);
    }

    @Override
    protected String getAuthorityCode(CoordinateOperation coordinateOperation) {
        Identifier identifier = IdentifiedObjects.getIdentifier((IdentifiedObject)coordinateOperation, (Citation)Citations.EPSG);
        return identifier != null ? identifier.getCode() : IdentifiedObjects.getIdentifierOrName((IdentifiedObject)coordinateOperation);
    }

    @Override
    protected CoordinateOperation createObject(String string) throws FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem;
        Integer n = this.projections.get(string);
        if (n != null && (coordinateReferenceSystem = ((CRSAuthorityFactory)this.factory).createCoordinateReferenceSystem(String.valueOf(n))) instanceof GeneralDerivedCRS) {
            return ((GeneralDerivedCRS)coordinateReferenceSystem).getConversionFromBase();
        }
        return ((CoordinateOperationAuthorityFactory)this.factory).createCoordinateOperation(string);
    }
}

