/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public class SQLTranslator
implements Function<String, String> {
    private static final String[] SENTINEL = new String[]{"Coordinate Reference System", "coordinatereferencesystem", "epsg_coordinatereferencesystem"};
    private static final int MIXED_CASE = 0;
    static final String TABLE_PREFIX = "epsg_";
    private static final String[] BOOLEAN_COLUMNS = new String[]{"SHOW_CRS", "SHOW_OPERATION", "DEPRECATED"};
    private static final String ENUMERATION_COLUMN = "OBJECT_TABLE_NAME";
    private String catalog;
    private String schema;
    private boolean isPrefixed;
    private final Map<String, String> accessToAnsi;
    private boolean quoteTableNames;
    private final String quote;
    private String tableNameEnum;
    private boolean useBoolean;
    private boolean isTableFound;

    public SQLTranslator(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        ArgumentChecks.ensureNonNull((String)"md", (Object)databaseMetaData);
        this.quote = databaseMetaData.getIdentifierQuoteString().trim();
        this.accessToAnsi = new HashMap<String, String>(4);
        this.catalog = string;
        this.schema = string2;
        this.setup(databaseMetaData);
    }

    final void setup(DatabaseMetaData databaseMetaData) throws SQLException {
        Object object;
        Object object2;
        boolean bl = databaseMetaData.storesUpperCaseIdentifiers();
        String string = databaseMetaData.getSearchStringEscape();
        String string2 = SQLUtilities.escape((String)this.schema, (String)string);
        int n = SENTINEL.length;
        while (--n >= 0) {
            object2 = SENTINEL[n];
            if (bl && n != 0) {
                object2 = ((String)object2).toUpperCase(Locale.US);
            }
            object = databaseMetaData.getTables(this.catalog, string2, (String)object2, null);
            try {
                if (!object.next()) continue;
                this.isTableFound = true;
                this.isPrefixed = ((String)object2).startsWith(TABLE_PREFIX);
                this.quoteTableNames = n == 0;
                do {
                    this.catalog = object.getString("TABLE_CAT");
                    this.schema = object.getString("TABLE_SCHEM");
                } while (!"EPSG".equalsIgnoreCase(this.schema) && object.next());
                if (this.schema == null) {
                    this.schema = "";
                }
                string2 = SQLUtilities.escape((String)this.schema, (String)string);
                break;
            }
            finally {
                if (object == null) continue;
                object.close();
            }
        }
        n = 1;
        this.accessToAnsi.clear();
        if (this.quoteTableNames) {
            object2 = databaseMetaData.getColumns(this.catalog, string2, "Coordinate Axis", "ORDER");
            try {
                n = !object2.next() ? 1 : 0;
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
        } else {
            this.accessToAnsi.put("Coordinate_Operation", "coordoperation");
            this.accessToAnsi.put("Parameter", "param");
        }
        if (n != 0) {
            this.accessToAnsi.put("ORDER", "coord_axis_order");
        }
        object2 = "DEPRECATED";
        object = ENUMERATION_COLUMN;
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            object2 = ((String)object2).toLowerCase(Locale.US);
            object = ((String)object).toLowerCase(Locale.US);
        }
        String string3 = this.isPrefixed ? SQLUtilities.escape((String)TABLE_PREFIX, (String)string) + '%' : null;
        try (ResultSet resultSet = databaseMetaData.getColumns(this.catalog, string2, string3, (String)object2);){
            while (resultSet.next()) {
                if (!CharSequences.endsWith((CharSequence)resultSet.getString("TABLE_NAME"), (CharSequence)"Datum", (boolean)true)) continue;
                int n2 = resultSet.getInt("DATA_TYPE");
                this.useBoolean = n2 == 16 || n2 == -7;
                break;
            }
        }
        resultSet = databaseMetaData.getColumns(this.catalog, string2, string3, (String)object);
        try {
            while (resultSet.next()) {
                if (!CharSequences.endsWith((CharSequence)resultSet.getString("TABLE_NAME"), (CharSequence)"Alias", (boolean)true)) continue;
                String string4 = resultSet.getString("TYPE_NAME");
                if (!CharSequences.startsWith((CharSequence)string4, (CharSequence)"VARCHAR", (boolean)true)) {
                    this.tableNameEnum = string4;
                }
                break;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    final boolean isTableFound() {
        return this.isTableFound;
    }

    static String tableNotFound(Locale locale) {
        return Errors.getResources((Locale)locale).getString((short)126, (Object)SENTINEL[0]);
    }

    final boolean useBoolean() {
        return this.useBoolean;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    @Override
    public String apply(String string) {
        int n;
        int n2;
        int n3;
        if (this.quote.isEmpty() && this.accessToAnsi.isEmpty() && SQLTranslator.isEmpty(this.schema) && SQLTranslator.isEmpty(this.catalog)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        int n4 = 0;
        while ((n3 = string.indexOf(91, n4)) >= 0) {
            String string2;
            stringBuilder.append(string, n4, n3);
            n4 = string.indexOf(93, ++n3);
            if (n4 < 0) {
                throw new IllegalArgumentException(Errors.format((short)84, (Object)string.substring(n3), (Object)Character.valueOf(']')));
            }
            if (CharSequences.isUpperCase((CharSequence)(string2 = string.substring(n3, n4++)))) {
                stringBuilder.append(this.accessToAnsi.getOrDefault(string2, string2));
                continue;
            }
            this.appendIdentifier(stringBuilder, string2);
        }
        stringBuilder.append(string, n4, string.length());
        if (this.useBoolean && (n2 = stringBuilder.indexOf("WHERE")) >= 0) {
            n2 += 5;
            for (String string3 : BOOLEAN_COLUMNS) {
                int n5 = stringBuilder.indexOf(string3, n2);
                if (n5 < 0 || SQLTranslator.replaceIfEquals(stringBuilder, n5 += string3.length(), "=0", "=FALSE") || SQLTranslator.replaceIfEquals(stringBuilder, n5, "<>0", "=TRUE") || (n5 = stringBuilder.lastIndexOf("(", n5)) <= n2) continue;
                SQLTranslator.replaceIfEquals(stringBuilder, n5 - 3, "ABS", "");
            }
        }
        if (this.tableNameEnum != null && (n = stringBuilder.lastIndexOf("OBJECT_TABLE_NAME=?")) >= 0) {
            stringBuilder.replace(n += ENUMERATION_COLUMN.length() + 1, n + 1, "CAST(? AS " + this.tableNameEnum + ')');
        }
        return stringBuilder.toString();
    }

    private void appendIdentifier(StringBuilder stringBuilder, String string) {
        if (!SQLTranslator.isEmpty(this.catalog)) {
            stringBuilder.append(this.quote).append(this.catalog).append(this.quote).append('.');
        }
        if (!SQLTranslator.isEmpty(this.schema)) {
            stringBuilder.append(this.quote).append(this.schema).append(this.quote).append('.');
        }
        if (this.quoteTableNames) {
            stringBuilder.append(this.quote);
        }
        if (this.isPrefixed) {
            stringBuilder.append(TABLE_PREFIX);
        }
        if (this.quoteTableNames) {
            stringBuilder.append(this.accessToAnsi.getOrDefault(string, string)).append(this.quote);
        } else {
            for (String string2 : string.split("\\s")) {
                stringBuilder.append(this.accessToAnsi.getOrDefault(string2, string2));
            }
        }
    }

    private static boolean replaceIfEquals(StringBuilder stringBuilder, int n, String string, String string2) {
        if (CharSequences.regionMatches((CharSequence)stringBuilder, (int)n, (CharSequence)string)) {
            stringBuilder.replace(n, n + string.length(), string2);
            return true;
        }
        return false;
    }
}

