/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.referencing.j2d.IntervalRectangle;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public final class AffineTransforms2D
extends Static {
    private AffineTransforms2D() {
    }

    public static AffineTransform castOrCopy(MathTransform mathTransform) throws IllegalArgumentException {
        if (mathTransform == null || mathTransform instanceof AffineTransform) {
            return (AffineTransform)mathTransform;
        }
        if (mathTransform instanceof LinearTransform) {
            return AffineTransforms2D.castOrCopy(((LinearTransform)mathTransform).getMatrix());
        }
        throw new IllegalArgumentException(Resources.format((short)59));
    }

    public static AffineTransform castOrCopy(Matrix matrix) throws IllegalArgumentException {
        if (matrix == null || matrix instanceof AffineTransform) {
            return (AffineTransform)matrix;
        }
        MatrixSIS.ensureSizeMatch(3, 3, matrix);
        if (!Matrices.isAffine(matrix)) {
            throw new IllegalArgumentException(Resources.format((short)59));
        }
        return new AffineTransform(matrix.getElement(0, 0), matrix.getElement(1, 0), matrix.getElement(0, 1), matrix.getElement(1, 1), matrix.getElement(0, 2), matrix.getElement(1, 2));
    }

    public static Matrix3 toMatrix(AffineTransform affineTransform) {
        return new Matrix3(affineTransform.getScaleX(), affineTransform.getShearX(), affineTransform.getTranslateX(), affineTransform.getShearY(), affineTransform.getScaleY(), affineTransform.getTranslateY(), 0.0, 0.0, 1.0);
    }

    public static LinearTransform toMathTransform(AffineTransform affineTransform) {
        if (affineTransform == null || affineTransform instanceof LinearTransform) {
            return (LinearTransform)((Object)affineTransform);
        }
        return new AffineTransform2D(affineTransform);
    }

    public static Shape transform(AffineTransform affineTransform, Shape shape, boolean bl) {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)affineTransform);
        if (shape == null) {
            return null;
        }
        int n = affineTransform.getType();
        if (n == 0) {
            return shape;
        }
        if ((n & 0x30) == 0) {
            if (shape instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)shape;
                return AffineTransforms2D.transform(affineTransform, rectangle2D, bl ? rectangle2D : null);
            }
            if ((n & 0x58) == 0 && shape instanceof RectangularShape) {
                RectangularShape rectangularShape = (RectangularShape)shape;
                if (!bl) {
                    rectangularShape = (RectangularShape)rectangularShape.clone();
                }
                Rectangle2D rectangle2D = rectangularShape.getFrame();
                rectangularShape.setFrame(AffineTransforms2D.transform(affineTransform, rectangle2D, rectangle2D));
                return rectangularShape;
            }
        }
        if (shape instanceof Path2D) {
            Path2D path2D = (Path2D)shape;
            if (bl) {
                path2D.transform(affineTransform);
            } else {
                shape = path2D.createTransformedShape(affineTransform);
            }
        } else if (shape instanceof Area) {
            Area area = (Area)shape;
            if (bl) {
                area.transform(affineTransform);
            } else {
                shape = area.createTransformedArea(affineTransform);
            }
        } else {
            shape = new Path2D.Double(shape, affineTransform);
        }
        return shape;
    }

    public static Rectangle2D transform(AffineTransform affineTransform, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)affineTransform);
        if (rectangle2D == null) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        Point2D.Double double_ = new Point2D.Double();
        for (int i = 0; i < 4; ++i) {
            double_.x = (i & 1) == 0 ? rectangle2D.getMinX() : rectangle2D.getMaxX();
            double_.y = (i & 2) == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
            affineTransform.transform(double_, double_);
            if (double_.x < d) {
                d = double_.x;
            }
            if (double_.x > d3) {
                d3 = double_.x;
            }
            if (double_.y < d2) {
                d2 = double_.y;
            }
            if (!(double_.y > d4)) continue;
            d4 = double_.y;
        }
        if (rectangle2D2 != null) {
            rectangle2D2.setRect(d, d2, d3 - d, d4 - d2);
            return rectangle2D2;
        }
        return new IntervalRectangle(d, d2, d3, d4);
    }

    public static Rectangle2D inverseTransform(AffineTransform affineTransform, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws NoninvertibleTransformException {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)affineTransform);
        if (rectangle2D == null) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        Point2D.Double double_ = new Point2D.Double();
        for (int i = 0; i < 4; ++i) {
            double_.x = (i & 1) == 0 ? rectangle2D.getMinX() : rectangle2D.getMaxX();
            double_.y = (i & 2) == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
            affineTransform.inverseTransform(double_, double_);
            if (double_.x < d) {
                d = double_.x;
            }
            if (double_.x > d3) {
                d3 = double_.x;
            }
            if (double_.y < d2) {
                d2 = double_.y;
            }
            if (!(double_.y > d4)) continue;
            d4 = double_.y;
        }
        if (rectangle2D2 != null) {
            rectangle2D2.setRect(d, d2, d3 - d, d4 - d2);
            return rectangle2D2;
        }
        return new IntervalRectangle(d, d2, d3, d4);
    }

    public static Point2D inverseDeltaTransform(AffineTransform affineTransform, Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        double d;
        double d2;
        double d3;
        ArgumentChecks.ensureNonNull((String)"transform", (Object)affineTransform);
        if (point2D == null) {
            return null;
        }
        double d4 = affineTransform.getScaleX();
        double d5 = d4 * (d3 = affineTransform.getScaleY()) - (d2 = affineTransform.getShearX()) * (d = affineTransform.getShearY());
        if (!(Math.abs(d5) > Double.MIN_VALUE)) {
            throw new NoninvertibleTransformException(null);
        }
        double d6 = point2D.getX();
        double d7 = point2D.getY();
        double d8 = (d6 * d3 - d7 * d2) / d5;
        double d9 = (d7 * d4 - d6 * d) / d5;
        if (point2D2 != null) {
            point2D2.setLocation(d8, d9);
            return point2D2;
        }
        return new Point2D.Double(d8, d9);
    }

    public static int getSwapXY(AffineTransform affineTransform) {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)affineTransform);
        int n = AffineTransforms2D.getFlip(affineTransform);
        if (n != 0) {
            double d = AffineTransforms2D.getScaleX0(affineTransform);
            double d2 = AffineTransforms2D.getScaleY0(affineTransform) * (double)n;
            double d3 = Math.abs(affineTransform.getShearY() / d2 - affineTransform.getShearX() / d);
            double d4 = Math.abs(affineTransform.getScaleY() / d2 + affineTransform.getScaleX() / d);
            if (d4 > d3) {
                return 1;
            }
            if (d4 < d3) {
                return -1;
            }
        }
        return 0;
    }

    public static double getRotation(AffineTransform affineTransform) {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)affineTransform);
        int n = AffineTransforms2D.getFlip(affineTransform);
        if (n != 0) {
            double d = AffineTransforms2D.getScaleX0(affineTransform);
            double d2 = AffineTransforms2D.getScaleY0(affineTransform) * (double)n;
            return Math.atan2(affineTransform.getShearY() / d2 - affineTransform.getShearX() / d, affineTransform.getScaleY() / d2 + affineTransform.getScaleX() / d);
        }
        return Double.NaN;
    }

    public static int getFlip(AffineTransform affineTransform) {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)affineTransform);
        double d = Math.signum(affineTransform.getScaleX());
        double d2 = Math.signum(affineTransform.getScaleY());
        double d3 = Math.signum(affineTransform.getShearX());
        double d4 = Math.signum(affineTransform.getShearY());
        if (d == d2 && d3 == -d4) {
            return 1;
        }
        if (d == -d2 && d3 == d4) {
            return -1;
        }
        return 0;
    }

    public static double getScaleX0(AffineTransform affineTransform) {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)affineTransform);
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getShearX();
        if (d2 == 0.0) {
            return Math.abs(d);
        }
        if (d == 0.0) {
            return Math.abs(d2);
        }
        return Math.hypot(d, d2);
    }

    public static double getScaleY0(AffineTransform affineTransform) {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)affineTransform);
        double d = affineTransform.getScaleY();
        double d2 = affineTransform.getShearY();
        if (d2 == 0.0) {
            return Math.abs(d);
        }
        if (d == 0.0) {
            return Math.abs(d2);
        }
        return Math.hypot(d, d2);
    }

    public static double getScale(AffineTransform affineTransform) {
        return 0.5 * (AffineTransforms2D.getScaleX0(affineTransform) + AffineTransforms2D.getScaleY0(affineTransform));
    }
}

