/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.projection.AuthalicConversion;
import org.apache.sis.referencing.operation.projection.Mercator;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class AuthalicMercator
extends AuthalicConversion {
    private static final long serialVersionUID = -3546152970105798436L;
    static final int TYPE = 3;

    AuthalicMercator(Mercator mercator) {
        super(null, mercator);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        double d = dArray[n + 1];
        double d2 = this.sin\u03b2(Math.sin(d));
        if (dArray2 != null) {
            dArray2[n2] = dArray[n];
            dArray2[n2 + 1] = MathFunctions.atanh((double)d2);
        }
        return bl ? new Matrix2(1.0, 0.0, 0.0, 1.0 / Math.sqrt(1.0 - d2 * d2)) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (dArray != dArray2 || n != n2) {
            super.transform(dArray, n, dArray2, n2, n3);
        } else {
            --n2;
            while (--n3 >= 0) {
                double d = dArray2[n2 += 2];
                dArray2[n2] = MathFunctions.atanh((double)this.sin\u03b2(Math.sin(d)));
            }
        }
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n + 1];
        dArray2[n2] = dArray[n];
        dArray2[n2 + 1] = this.\u03c6(Math.tanh(d));
    }
}

