/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Collections;
import java.util.Map;
import javax.measure.IncommensurableException;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.CartesianToPolar;
import org.apache.sis.referencing.operation.transform.CartesianToSpherical;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.PolarToCartesian;
import org.apache.sis.referencing.operation.transform.SphericalToCartesian;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.util.FactoryException;

abstract class CoordinateSystemTransform
extends AbstractMathTransform {
    private final int dimension;
    private final transient OperationMethod method;
    private final transient OperationMethod method3D;
    final transient ContextualParameters context;
    private volatile transient MathTransform complete;
    private volatile transient MathTransform passthrough;

    CoordinateSystemTransform(String string, String string2, int n) {
        this.dimension = n;
        this.method = CoordinateSystemTransform.method(string);
        this.method3D = string2 != null ? CoordinateSystemTransform.method(string2) : this.method;
        this.context = new ContextualParameters(this.method.getParameters(), n, n);
    }

    private static OperationMethod method(String string) {
        Map<String, ImmutableIdentifier> map = Collections.singletonMap("name", new ImmutableIdentifier(Citations.SIS, "SIS", string));
        DefaultParameterDescriptorGroup defaultParameterDescriptorGroup = new DefaultParameterDescriptorGroup(map, 1, 1, new GeneralParameterDescriptor[0]);
        return new DefaultOperationMethod(map, defaultParameterDescriptorGroup);
    }

    final MathTransform completeTransform(MathTransformFactory mathTransformFactory) throws FactoryException {
        MathTransform mathTransform = this.complete;
        if (mathTransform == null) {
            mathTransform = this.context.completeTransform(mathTransformFactory, this);
            if (DefaultFactories.isDefaultInstance(MathTransformFactory.class, (Object)mathTransformFactory)) {
                this.complete = mathTransform;
            }
        }
        return mathTransform;
    }

    final MathTransform passthrough(MathTransformFactory mathTransformFactory) throws FactoryException {
        MathTransform mathTransform = this.passthrough;
        if (mathTransform == null) {
            mathTransform = mathTransformFactory.createPassThroughTransform(0, this.completeTransform(mathTransformFactory), 1);
            if (DefaultFactories.isDefaultInstance(MathTransformFactory.class, (Object)mathTransformFactory)) {
                this.passthrough = mathTransform;
            }
        }
        return mathTransform;
    }

    @Override
    public final int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public final int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public final ParameterValueGroup getParameterValues() {
        return this.context;
    }

    @Override
    protected final ContextualParameters getContextualParameters() {
        return this.context;
    }

    static MathTransform create(MathTransformFactory mathTransformFactory, CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2, ThreadLocal<OperationMethod> threadLocal) throws FactoryException {
        int n = 0;
        CoordinateSystemTransform coordinateSystemTransform = null;
        if (coordinateSystem instanceof CartesianCS) {
            if (coordinateSystem2 instanceof SphericalCS) {
                coordinateSystemTransform = CartesianToSpherical.INSTANCE;
            } else if (coordinateSystem2 instanceof PolarCS) {
                coordinateSystemTransform = CartesianToPolar.INSTANCE;
            } else if (coordinateSystem2 instanceof CylindricalCS) {
                coordinateSystemTransform = CartesianToPolar.INSTANCE;
                n = 1;
            }
        } else if (coordinateSystem2 instanceof CartesianCS) {
            if (coordinateSystem instanceof SphericalCS) {
                coordinateSystemTransform = SphericalToCartesian.INSTANCE;
            } else if (coordinateSystem instanceof PolarCS) {
                coordinateSystemTransform = PolarToCartesian.INSTANCE;
            } else if (coordinateSystem instanceof CylindricalCS) {
                coordinateSystemTransform = PolarToCartesian.INSTANCE;
                n = 1;
            }
        }
        Throwable throwable = null;
        try {
            if (coordinateSystemTransform == null) {
                return mathTransformFactory.createAffineTransform(CoordinateSystems.swapAndScaleAxes(coordinateSystem, coordinateSystem2));
            }
            if (coordinateSystem.getDimension() == coordinateSystemTransform.getSourceDimensions() + n && coordinateSystem2.getDimension() == coordinateSystemTransform.getTargetDimensions() + n) {
                MathTransform mathTransform = n == 0 ? coordinateSystemTransform.completeTransform(mathTransformFactory) : coordinateSystemTransform.passthrough(mathTransformFactory);
                MathTransform mathTransform2 = mathTransformFactory.createAffineTransform(CoordinateSystems.swapAndScaleAxes(coordinateSystem, CoordinateSystems.replaceAxes(coordinateSystem, AxesConvention.NORMALIZED)));
                MathTransform mathTransform3 = mathTransformFactory.createAffineTransform(CoordinateSystems.swapAndScaleAxes(CoordinateSystems.replaceAxes(coordinateSystem2, AxesConvention.NORMALIZED), coordinateSystem2));
                MathTransform mathTransform4 = mathTransformFactory.createConcatenatedTransform(mathTransform2, mathTransformFactory.createConcatenatedTransform(mathTransform, mathTransform3));
                threadLocal.set(n == 0 ? coordinateSystemTransform.method : coordinateSystemTransform.method3D);
                return mathTransform4;
            }
        }
        catch (IllegalArgumentException | IncommensurableException throwable2) {
            throwable = throwable2;
        }
        throw new OperationNotFoundException(Resources.format((short)13, WKTUtilities.toType(CoordinateSystem.class, coordinateSystem.getClass()), WKTUtilities.toType(CoordinateSystem.class, coordinateSystem2.getClass())), throwable);
    }
}

