/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.server.filter;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.filter.Filter;

public class ResourceFilter
extends AbstractFilter
implements Filter {
    protected static final Log LOG = ExoLogger.getLogger(ResourceFilter.class);
    protected static final String METHOD_GET = "GET";
    protected static final String CACHE_CONTROL = "Cache-Control";
    private static final String NO_VERSION = "".intern();
    private static AtomicReference<String> version = new AtomicReference();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!PropertyManager.isDevelopping()) {
            String ver;
            HttpServletRequest httpReq = (HttpServletRequest)request;
            HttpServletResponse httpRes = (HttpServletResponse)response;
            String method = httpReq.getMethod();
            if (method != null && METHOD_GET.equals(method) && !NO_VERSION.equals(ver = this.version())) {
                if (ver.indexOf("Beta") > 0 || ver.indexOf("RC") > 0 || ver.indexOf("M") > 0) {
                    httpRes.setHeader(CACHE_CONTROL, "max-age=3600,s-maxage=3600");
                    response = new FixedCacheResponse(httpRes);
                } else if (ver.endsWith("SNAPSHOT")) {
                    httpRes.setHeader(CACHE_CONTROL, "max-age=1200,s-maxage=1200");
                    response = new FixedCacheResponse(httpRes);
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    protected String version() {
        Package myPackage;
        String ver = version.get();
        if (ver == null && (myPackage = ((Object)((Object)this)).getClass().getPackage()) != null) {
            ver = myPackage.getImplementationVersion();
            if (ver == null) {
                ver = NO_VERSION;
            }
            version.set(ver);
        }
        return ver;
    }

    class FixedCacheResponse
    extends HttpServletResponseWrapper {
        protected FixedCacheResponse(HttpServletResponse response) {
            super(response);
        }

        public void setHeader(String name, String value) {
            if (!ResourceFilter.CACHE_CONTROL.equals(name)) {
                super.setHeader(name, value);
            }
        }

        public void addHeader(String name, String value) {
            if (!ResourceFilter.CACHE_CONTROL.equals(name)) {
                super.addHeader(name, value);
            }
        }
    }
}

