/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.server.filter;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.io.IOException;
import java.security.Key;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.webconferencing.WebConferencingService;

public class SessionFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpRes = (HttpServletResponse)response;
        if (httpReq.getRemoteUser() != null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            WebConferencingService webconfService = (WebConferencingService)container.getComponentInstanceOfType(WebConferencingService.class);
            String sessionToken = Jwts.builder().setSubject("exo-webconf").claim("username", (Object)httpReq.getRemoteUser()).signWith((Key)Keys.hmacShaKeyFor((byte[])webconfService.getSecretKey().getBytes())).compact();
            Cookie cookie = new Cookie(WebConferencingService.SESSION_TOKEN_COOKIE, sessionToken);
            cookie.setPath("/");
            cookie.setMaxAge(2400);
            cookie.setHttpOnly(true);
            cookie.setSecure(request.isSecure());
            httpRes.addCookie(cookie);
        }
        chain.doFilter(request, response);
    }
}

