/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.binding.job;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingQueue;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class QueueGroupSpaceBindingJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(QueueGroupSpaceBindingJob.class);
    private GroupSpaceBindingService groupSpaceBindingService;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.groupSpaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
        LOG.info((Object)"Start treating GroupSpaceBinding queue");
        GroupSpaceBindingQueue firstBindingQueue = null;
        do {
            try {
                firstBindingQueue = this.groupSpaceBindingService.findFirstGroupSpaceBindingQueue();
                if (firstBindingQueue == null) continue;
                GroupSpaceBinding firstBindingInBindingQueue = firstBindingQueue.getGroupSpaceBinding();
                String queueAction = firstBindingQueue.getAction();
                if (queueAction.equals(GroupSpaceBindingQueue.ACTION_CREATE)) {
                    LOG.info("Proceeding binding between space with ID: {} and group: {}", new Object[]{firstBindingInBindingQueue.getSpaceId(), firstBindingInBindingQueue.getGroup()});
                    this.groupSpaceBindingService.bindUsersFromGroupSpaceBinding(firstBindingInBindingQueue);
                    this.groupSpaceBindingService.deleteFromBindingQueue(firstBindingQueue);
                    continue;
                }
                LOG.info("Proceeding removing binding between space with ID: {} and group: {}", new Object[]{firstBindingInBindingQueue.getSpaceId(), firstBindingInBindingQueue.getGroup()});
                this.groupSpaceBindingService.deleteGroupSpaceBinding(firstBindingInBindingQueue);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to treat GroupSpaceBinding queue", (Throwable)e);
                break;
            }
        } while (firstBindingQueue != null);
        LOG.info((Object)"End treating GroupSpaceBinding queue");
    }
}

