/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListener;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class ActivityESListener
implements ActivityListener {
    private static final Log LOG = ExoLogger.getExoLogger(ActivityESListener.class);

    public void saveActivity(ActivityLifeCycleEvent event) {
        this.reindexActivity(event.getActivity(), "save activity");
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
        this.reindexActivity(event.getActivity(), "update activity");
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        this.reindexActivity(event.getActivity(), "save comment");
    }

    public void updateComment(ActivityLifeCycleEvent event) {
        this.reindexActivity(event.getActivity(), "update comment");
    }

    public void deleteActivity(ActivityLifeCycleEvent event) {
        this.unindexActivity(event.getActivity(), "delete comment");
    }

    public void deleteComment(ActivityLifeCycleEvent event) {
        this.unindexActivity(event.getActivity(), "delete comment");
    }

    private void reindexActivity(ExoSocialActivity activity, String cause) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        LOG.debug("Notifying indexing service for activity with id={}. Cause: {}", new Object[]{activity.getId(), cause});
        indexingService.reindex("activity", activity.getId());
    }

    private void unindexActivity(ExoSocialActivity activity, String cause) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        LOG.debug("Notifying indexing service for activity with id={}. Cause: {}", new Object[]{activity.getId(), cause});
        indexingService.unindex("activity", activity.getId());
    }
}

