/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.core.jpa.storage.entity.MetadataEntity;

public class MetadataDAO
extends GenericDAOJPAImpl<MetadataEntity, Long> {
    private static final String AUDIENCE_IDS = "audienceIds";
    private static final String CREATOR_ID = "creatorId";
    private static final String METADATA_TYPE = "type";
    private static final String METADATA_NAME_PART = "term";

    public List<String> getMetadataNamesByAudiences(long metadataTypeId, Set<Long> audienceIds, long limit) {
        List result;
        if (CollectionUtils.isEmpty(audienceIds)) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.getMetadataNamesByAudiences", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(AUDIENCE_IDS, audienceIds);
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<String> getMetadataNamesByCreator(long metadataTypeId, long creatorIdentityId, long limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.getMetadataNamesByCreator", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(CREATOR_ID, (Object)creatorIdentityId);
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<String> getMetadataNamesByUser(long metadataTypeId, long creatorIdentityId, Set<Long> audienceIds, long limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.getMetadataNamesByUser", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(AUDIENCE_IDS, audienceIds);
        query.setParameter(CREATOR_ID, (Object)creatorIdentityId);
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<String> findMetadataNameByAudiencesAndQuery(String term, long metadataTypeId, Set<Long> audienceIds, long limit) {
        List result;
        if (CollectionUtils.isEmpty(audienceIds)) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.findMetadataNameByAudiencesAndQuery", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(AUDIENCE_IDS, audienceIds);
        query.setParameter(METADATA_NAME_PART, (Object)("%" + StringUtils.lowerCase((String)term) + "%"));
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<String> findMetadataNameByCreatorAndQuery(String term, long metadataTypeId, long creatorIdentityId, long limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.findMetadataNameByCreatorAndQuery", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(CREATOR_ID, (Object)creatorIdentityId);
        query.setParameter(METADATA_NAME_PART, (Object)("%" + StringUtils.lowerCase((String)term) + "%"));
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<String> findMetadataNamesByUserAndQuery(String term, long metadataTypeId, long creatorIdentityId, Set<Long> audienceIds, long limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.findMetadataNameByUserAndQuery", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(AUDIENCE_IDS, audienceIds);
        query.setParameter(CREATOR_ID, (Object)creatorIdentityId);
        query.setParameter(METADATA_NAME_PART, (Object)("%" + StringUtils.lowerCase((String)term) + "%"));
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public MetadataEntity findMetadata(long type, String name, long audienceId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.findMetadata", MetadataEntity.class);
        query.setParameter(METADATA_TYPE, (Object)type);
        query.setParameter("name", (Object)name);
        query.setParameter("audienceId", (Object)audienceId);
        try {
            return (MetadataEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<MetadataEntity> getMetadatas(long type, long limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.getMetadatas", MetadataEntity.class);
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        query.setParameter(METADATA_TYPE, (Object)type);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<String> getMetadatasByProperty(String propertyKey, String propertyValue, long limit) {
        try {
            Query query = this.getMetadatasByPropertyQuery(propertyKey, propertyValue);
            return this.getResultsFromQuery(query, limit);
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    private Query getMetadatasByPropertyQuery(String propertyKey, String propertyValue) {
        StringBuilder queryStringBuilder = null;
        queryStringBuilder = new StringBuilder("SELECT DISTINCT sm.metadata_id ");
        queryStringBuilder.append(" FROM SOC_METADATAS sm \n");
        queryStringBuilder.append(" INNER JOIN SOC_METADATA_PROPERTIES sm_prop \n");
        queryStringBuilder.append(" ON sm.metadata_id = sm_prop.metadata_id \n");
        queryStringBuilder.append(" AND EXISTS ( SELECT sm_prop_tmp.metadata_id FROM SOC_METADATA_PROPERTIES as sm_prop_tmp \n");
        queryStringBuilder.append(" WHERE sm_prop_tmp.metadata_id = sm.metadata_id \n");
        queryStringBuilder.append(" AND sm_prop_tmp.name = '").append(propertyKey).append("' \n");
        queryStringBuilder.append(" AND sm_prop_tmp.value = '").append(propertyValue).append("' ) \n");
        return this.getEntityManager().createNativeQuery(queryStringBuilder.toString());
    }

    private List<String> getResultsFromQuery(Query query, long limit) {
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        List resultList = query.getResultList();
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : resultList) {
            String resultObject = String.valueOf(object);
            if (resultObject == null) continue;
            result.add(resultObject);
        }
        return result;
    }
}

