/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.upgrade;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CleanAppRegistryCategoryUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(CleanAppRegistryCategoryUpgradePlugin.class);
    private final EntityManagerService entityManagerService;
    private final PortalContainer container;
    private int cleanedCategoriesCount;

    public CleanAppRegistryCategoryUpgradePlugin(PortalContainer container, EntityManagerService entityManagerService, InitParams initParams) {
        super(initParams);
        this.container = container;
        this.entityManagerService = entityManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        boolean transactionStarted = false;
        LOG.info((Object)"Start clean application registry categories migration");
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        try {
            if (!entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().begin();
                transactionStarted = true;
            }
            Query nativeQuery = entityManager.createNativeQuery("DELETE FROM PORTAL_APP_CATEGORIES");
            this.cleanedCategoriesCount += nativeQuery.executeUpdate();
            LOG.info("End clean of '{}' application registry categories successful migration. It tooks {} ms.", new Object[]{this.cleanedCategoriesCount, System.currentTimeMillis() - startupTime});
            if (transactionStarted && entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().commit();
                entityManager.clear();
                entityManager.flush();
            }
        }
        catch (Exception e) {
            if (transactionStarted && entityManager.getTransaction().isActive() && entityManager.getTransaction().getRollbackOnly()) {
                entityManager.getTransaction().rollback();
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public int getCleanedCategoriesCount() {
        return this.cleanedCategoriesCount;
    }
}

