/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ActivityTypeUtils {
    private static final Log LOG = ExoLogger.getLogger(ActivityTypeUtils.class);
    public static String EXO_ACTIVITY_INFO = "exo:activityInfo";
    public static String EXO_ACTIVITY_ID = "exo:activityId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attachActivityId(Node ownerNode, String activityId) {
        Node verNode = null;
        try {
            if (!ownerNode.isCheckedOut()) {
                verNode = ActivityTypeUtils.checkout(ownerNode);
            }
            if (!ownerNode.isNodeType(EXO_ACTIVITY_INFO) && ownerNode.canAddMixin(EXO_ACTIVITY_INFO)) {
                ownerNode.addMixin(EXO_ACTIVITY_INFO);
            }
            ownerNode.setProperty(EXO_ACTIVITY_ID, activityId);
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Failed to attach activityId " + activityId), (Throwable)e);
        }
        finally {
            if (verNode != null) {
                try {
                    verNode.save();
                    verNode.checkin();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Can't checkin node", (Throwable)ex);
                }
            }
        }
    }

    private static Node checkout(Node ownerNode) throws RepositoryException {
        if (ownerNode.isNodeType("mix:versionable")) {
            ownerNode.checkout();
            return ownerNode;
        }
        try {
            return ActivityTypeUtils.checkout(ownerNode.getParent());
        }
        catch (ItemNotFoundException ex) {
            LOG.debug((Object)"no parent for root node");
            return null;
        }
    }

    public static String getActivityId(Node ownerNode) {
        try {
            if (ownerNode.isNodeType(EXO_ACTIVITY_INFO)) {
                return ownerNode.getProperty(EXO_ACTIVITY_ID).getString();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get value of exo:activityId.", (Throwable)e);
        }
        return null;
    }

    public static void removeAttchAtivityId(Node ownerNode) {
        ActivityTypeUtils.attachActivityId(ownerNode, "");
    }
}

