/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.indexing.listeners;

import java.util.HashMap;
import org.exoplatform.commons.api.indexing.IndexingService;
import org.exoplatform.commons.api.indexing.data.SearchEntry;
import org.exoplatform.commons.api.indexing.data.SearchEntryId;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class UnifiedSearchSocialSpaceListener
extends SpaceListenerPlugin {
    private static Log log = ExoLogger.getLogger(UnifiedSearchSocialSpaceListener.class);
    private final IndexingService indexingService;

    public UnifiedSearchSocialSpaceListener(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public void spaceCreated(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        if (this.indexingService != null) {
            HashMap<String, Space> content = new HashMap<String, Space>();
            content.put("space", spaceLifeCycleEvent.getSpace());
            SearchEntry searchEntry = new SearchEntry("social", "space", spaceLifeCycleEvent.getSpace().getId(), content);
            this.indexingService.add(searchEntry);
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        if (this.indexingService != null) {
            SearchEntryId searchEntryId = new SearchEntryId("social", "space", spaceLifeCycleEvent.getSpace().getId());
            this.indexingService.delete(searchEntryId);
        }
    }

    public void applicationAdded(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void applicationRemoved(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void applicationActivated(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void applicationDeactivated(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void joined(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void left(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void grantedLead(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void revokedLead(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void spaceRenamed(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void addInvitedUser(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void addPendingUser(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceUpdated(spaceLifeCycleEvent);
    }

    protected void spaceUpdated(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        if (this.indexingService != null) {
            HashMap<String, Space> content = new HashMap<String, Space>();
            content.put("space", spaceLifeCycleEvent.getSpace());
            SearchEntryId searchEntryId = new SearchEntryId("social", "space", spaceLifeCycleEvent.getSpace().getId());
            this.indexingService.update(searchEntryId, content);
        }
    }
}

