/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rpc.jgv3;

import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.rpc.impl.AbstractRPCService;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.RspList;

public class RPCServiceImpl
extends AbstractRPCService {
    public RPCServiceImpl(ExoContainerContext ctx, InitParams params, ConfigurationManager configManager) {
        super(ctx, params, configManager);
    }

    @Override
    protected Address getLocalAddress() {
        return this.channel.getAddress();
    }

    @Override
    public String getHostAddress() {
        String address = null;
        Address jgAddress = this.channel.getAddress();
        if (!(jgAddress instanceof IpAddress)) {
            jgAddress = (Address)this.channel.down(new Event(87, (Object)jgAddress));
        }
        if (jgAddress instanceof IpAddress) {
            address = ((IpAddress)jgAddress).getIpAddress().getHostAddress();
        } else {
            LOG.error((Object)("Unsupported Address object : " + jgAddress.getClass().getName()));
        }
        return address;
    }

    protected RspList<Object> castMessage(List<Address> dests, Message msg, boolean synchronous, long timeout) throws Exception {
        return this.dispatcher.castMessage(dests, msg, new RequestOptions(synchronous ? ResponseMode.GET_ALL : ResponseMode.GET_NONE, timeout));
    }

    @Override
    protected Channel createChannel() throws Exception {
        return new JChannel(this.configurator);
    }

    public void unblock() {
    }

    @Override
    protected List<Address> getMembers(View view) {
        return view.getMembers();
    }

    @Override
    protected void setObject(Message m, Object o) {
        m.setObject(o);
    }
}

