/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.common;

import java.io.Serializable;
import org.gatein.api.internal.ObjectToStringBuilder;

public class Pagination
implements Serializable {
    private final int offset;
    private final int limit;

    public Pagination(int offset, int limit) {
        if (limit == 0) {
            throw new IllegalArgumentException("limit cannot be 0 for pagination.");
        }
        this.offset = offset;
        this.limit = limit;
    }

    public int getPageNumber() {
        if (this.offset < this.limit || this.limit == 0) {
            return 1;
        }
        return this.offset / this.limit + 1;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public Pagination getNext() {
        return new Pagination(this.offset + this.limit, this.limit);
    }

    public Pagination getPrevious() {
        if (this.limit >= this.offset) {
            return new Pagination(0, this.limit);
        }
        return new Pagination(this.offset - this.limit, this.limit);
    }

    public String toString() {
        return ObjectToStringBuilder.toStringBuilder().add("offset", this.getOffset()).add("limit", this.getLimit()).add("pageNumber", this.getPageNumber()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pagination)) {
            return false;
        }
        Pagination pagination = (Pagination)o;
        return this.limit == pagination.limit && this.offset == pagination.offset;
    }

    public int hashCode() {
        int result = this.offset;
        result = 31 * result + this.limit;
        return result;
    }
}

